% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_tolerance.R
\name{tune_tolerance}
\alias{tune_tolerance}
\title{Tune tolerance parameter}
\usage{
tune_tolerance(
  img,
  actual,
  start_tol = NULL,
  extension = NULL,
  grid = NULL,
  maxiter = 200,
  index = "NB",
  my_index = NULL,
  plot = TRUE,
  fill_hull = FALSE,
  filter = FALSE,
  invert = FALSE,
  workers = NULL,
  verbose = TRUE
)
}
\arguments{
\item{img}{The image to be analyzed.}

\item{actual}{The actual number of objects.}

\item{start_tol}{An starting value for tolerance. Defaults to \code{1}.}

\item{extension}{The extension value. Defaults to \code{1}.}

\item{grid}{A list with a numeric sequence for \code{tolerance} and \code{extension}
values. When grid is informed, all combinations are tested and the residual
from \code{actual} value is plotted.}

\item{maxiter}{The maximum number of iterations. Default to 200.}

\item{index, my_index}{A character value specifying the target mode for
conversion to binary image when \code{foreground} and \code{background} are not
declared. Defaults to \code{"NB"} (normalized blue). See \code{\link[=image_index]{image_index()}} for
more details.}

\item{plot}{Logical. If \code{TRUE} (default) generates a plot showing the
results.}

\item{fill_hull}{Fill holes in the binary image? Defaults to \code{FALSE}. This is
useful to fill holes in objects that have portions with a color similar to
the background. IMPORTANT: Objects touching each other can be combined into
one single object, which may underestimate the number of objects in an
image.}

\item{filter}{Performs median filtering after image processing? defaults to
\code{FALSE}. See more at \code{\link[=image_filter]{image_filter()}}.}

\item{invert}{Inverts the binary image, if desired. This is useful to process
images with black background. Defaults to \code{FALSE}.}

\item{workers}{The number of multiple sections to be used in the computation.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}
}
\description{
Provides options for tunning \code{tolerance} parameter utilized in
\verb{[analyze_objects()]} in two ways:
\itemize{
\item Declaring the \code{actual} argument, an iterative algorithm will compute the
first analysis and sequentially increase the parameter \code{tolerance} if the
computed number of objects is greater than \code{actual} or reduce the parameter
\code{tolerance} if the computed number of objects is less than \code{actual}. If the
algorithm did not converge up to \code{maxiter} is reached, users can change the
default \code{extension} value.
\item The second way is to create a \code{grid} with \code{tolerance} and \code{extension}
values. When \code{grid} is informed, all combinations (made by
\code{\link[base:expand.grid]{base::expand.grid()}}) are tested and the residual from \code{actual} value is
plotted. Users can than find a better combination of parameters to use in
\code{analyze_objects()}.
}
}
\examples{
library(pliman)
if(FALSE){
 img <- image_pliman("soybean_touch.jpg")

 # starts with tolerance = 1
 tune_tolerance(img, actual = 30)

 # Using a grid of tolerance and extension values
 tune2 <-
   tune_tolerance(img,
                  actual = 30,
                  grid = list(tolerance = seq(0, 5, by = 0.1),
                              extension = 1:4), plot = TRUE)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
