% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocab.R
\docType{data}
\name{vocab}
\alias{vocab}
\title{Dataframe of response to vocabulary items from the 2018 General Social Survey}
\format{
A data frame with 1309 rows and 10 columns (items):
\describe{
  \item{wordA}{word A}
  \item{wordB}{word B}
  \item{wordC}{word C}
  \item{wordD}{word D}
  \item{wordE}{word E}
  \item{wordF}{word F}
  \item{wordG}{word G}
  \item{wordH}{word H}
  \item{wordI}{word I}
  \item{wordJ}{word J}
  }
}
\source{
\url{https://gss.norc.org}
}
\usage{
vocab
}
\description{
These data are responses to 10 vocabulary items from the GSS collected
in 2018 and retrieved July 2019 from https://gss.norc.org.  These data 
are provided as an example of binary items and how the package can fit
two parameter logistic models as either a GPCM or nominal model. Both
models should give the same results. There are 10 words and responses 
to them were were either correct or incorrect. There are 1309 
respondents in the data who gave answers to all items. The specific
words used are not released due to test security reasons. The 
instructions given to answering these items are as follows:
"We would like to know something about how people go about guessing words
they do not know. On this card are listed some words--you may know some of
them, and you may not know quite a few of them. On each line the first word
is in capital letters -- like BEAST. Then there are five other words. Tell
me the number of the word that comes closest to the meaning of the word in
capital letters. For example, if the word in capital letters is BEAST, you
would say "4" since "animal" comes closer to BEAST than any of the other
words. If you wish, I will read the words to you. These words are difficult
for almost everyone-- just give me your best guess if you are not sure of
the answer.
CIRCLE ONE CODE NUMBER FOR EACH ITEM BELOW."
}
\examples{
  data(vocab)
  head(vocab)

}
\keyword{datasets}
