% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ItemLoop.R
\name{ItemLoop}
\alias{ItemLoop}
\title{loops through items and up-dates estimates of scale values for each item in Nominal Model}
\usage{
ItemLoop(
  Master,
  item.log,
  Phi.mat = Phi.mat,
  PersonByItem,
  npersons,
  nitems,
  ntraits,
  ncat,
  nless,
  TraitByTrait,
  pq.mat,
  LambdaName,
  NuName,
  fitem
)
}
\arguments{
\item{Master}{Current master frame}

\item{item.log}{Iteration history for the items parameters}

\item{Phi.mat}{Current estimate of Phi.mat}

\item{PersonByItem}{Person by item adjacency matrix (same as inData)}

\item{npersons}{Number of persons}

\item{nitems}{Number of items}

\item{ntraits}{Number of traits}

\item{ncat}{Number of categories}

\item{nless}{Number of unique lambda and unique nus (ncat-1)}

\item{TraitByTrait}{TraitsByTrait adjacency matrix (sam as TraitAdj)}

\item{pq.mat}{One dimensional array for computing rest-scores}

\item{LambdaName}{Marginal effect names used in formula and item
data frame for item regressions}

\item{NuName}{Scale values names in used in formula and item
data frame for item regressions}

\item{fitem}{Formula for item regression}
}
\value{
Master	  Master data frame up-dated scale values for all items

item.log  Iteration history of item parameters where the last
                       row showing results from the current iteration
}
\description{
This is a core function of the pseudo-likelihood algorithm for items of
the nominal model. The function calls function 'ItemData' to create
the data frame for input into 'mnlogit', which is use to fit a conditional
multinomial model (i.e., a discrete choice model) for each item.  The
up-dated scale are put into the Master data frame and added to the
item.log array.  Generally the function would not run outside of
'fit.nominal' or 'ple.lma'.
}
