% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learningcurve_data.R
\name{learningcurve_data}
\alias{learningcurve_data}
\title{Generate descriptive summary for objects returned by functions in EHRsampling}
\usage{
learningcurve_data(
  x,
  y,
  method = "log",
  metric = "MCC",
  batchsize = 60,
  class.prob,
  pct.train = 0.8,
  nfold = 5,
  nrepeat = 10
)
}
\arguments{
\item{x}{a matrix of predictor variables}

\item{y}{a vector of binary outcome, encoded as a factor and denoted by 1 for events and 0 for non-events}

\item{method}{training method to get performance measurements. Available options are "log" (logistic regression, default),
"regul.log" (regularized logistic regression), "svm" (support vector machine), "rf" (random forest) and "lda" (linear discriminant analysis)}

\item{metric}{default = "MCC". The target performance estimation metric that you want to optimize. Other choice
can be "AUC".}

\item{batchsize}{sample size for each training batch}

\item{class.prob}{probability of the event}

\item{pct.train}{the percentage of data that goes to training. Default is 0.8}

\item{nfold}{number of folds in cross validation}

\item{nrepeat}{number of repeats for cross validation}
}
\value{
\code{learningcurve_data()} returns a data frame of sample size and the corresponding performance measurements.
}
\description{
Generate descriptive summary for objects returned by functions in EHRsampling.
}
