% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageInheritanceReporter.R
\docType{data}
\name{InheritanceReporter}
\alias{InheritanceReporter}
\title{Package Class Inheritance Reporter Class}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
InheritanceReporter
}
\description{
This reporter takes a package and traces the class inheritance
  structure. Currently the following object-oriented systems are supported:
  \itemize{
      \item{S4 Classes}
      \item{Reference Classes (sometimes informally called "R5")}
      \item{R6 Classes}
  }
  S3 classes are not supported, as their inheritance is defined on an ad hoc
  basis per object and not formally by class definitions.

  Note the following details about class naming:
  \itemize{
      \item{Reference Classes : The name passed as \code{Class} in
      \code{\link[methods:ReferenceClasses]{setRefClass}} is used as the node
      name by this reporter. This is the class name that is used when
      specifying inheritance. The generator object returned by
      \code{\link[methods:ReferenceClasses]{setRefClass}} does not have to be
      assigned and can have a different name.}
      \item{R6 Classes : The name of the generator object in the package
      namespace is used as the node name by this reporter. The generator
      object returned by \code{\link[R6:R6Class]{R6::R6Class}} is what is
      used when specifying inheritance. The name passed as \code{classname}
      passed to \code{\link[R6:R6Class]{R6::R6Class}} can be a different name
      or even NULL.}
 }

  For more info about R's built-in object-oriented systems, check out the
  relevant chapter in \href{http://adv-r.had.co.nz/OO-essentials.html}{Hadley
  Wickham's \emph{Advanced R}}. For more info about R6, check out their
  \href{https://r6.r-lib.org/index.html}{docs website} or the chapter in
  \href{https://adv-r.hadley.nz/r6.html}{\emph{Advanced R}'s second edition}.
}
\section{Public Methods}{

\describe{
    \item{\code{set_package(pkg_name, pkg_path)}}{
        \itemize{
            \item{Set properties of this reporter. If pkg_name overrides a
                previously-set package name, any cached data will be removed.}
            \item{\bold{Args:}}{
                \itemize{
                \item{\bold{\code{pkg_name}}: String with the name of the package.}
                \item{\bold{\code{pkg_path}}: Optional directory path to source
                  code of the package. It is used for calculating test coverage.
                  It can be an absolute or relative path.}
               }
            }
        }
    }
}
}

\seealso{
Other PackageReporters: \code{\link{DependencyReporter}},
  \code{\link{FunctionReporter}},
  \code{\link{SummaryReporter}}
}
\concept{PackageReporters}
\keyword{datasets}
