% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filecache.R
\name{get_relative_file_subdir}
\alias{get_relative_file_subdir}
\title{Given a relative file, determine its subdir in the package cache.}
\usage{
get_relative_file_subdir(pkg_info, relative_file)
}
\arguments{
\item{pkg_info, }{named list. Package identifier, see get_pkg_info() on how to get one.}

\item{relative_file, }{string or vector of strings. If a string, this function does nothing. If a vector of strings, a path is created from the elements using file.path, and the directory of it (determined by dirname()) is created.}
}
\value{
named list. The entries are: "has_subdir": logical, whether the file has a subdir. "relative_filepath": string. The input relative_file, flattened to a string. For files without subdir, this is identical to string in the parameter 'relative_file'. For others, it is the result of applying file.path() to the elements of the vector 'relative_file'. If "has_subdir" is TRUE, the following 2 fields also exist: "relative_subdir": string, subdir path relative to package cache dir. "absolute_subdir": string, absolute subdir path.
}
\description{
Given a relative file, determine its subdir in the package cache.
}
\keyword{internal}
