% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filecache.R
\name{get_absolute_path_for_files}
\alias{get_absolute_path_for_files}
\title{Construct absolute path for package cache files.}
\usage{
get_absolute_path_for_files(pkg_info, relative_filenames)
}
\arguments{
\item{pkg_info, }{named list. Package identifier, see get_pkg_info() on how to get one.}

\item{relative_filenames, }{vector of strings. A vector of filenames, relative to the package cache.}
}
\value{
vector of strings. The absolute paths.
}
\description{
Construct absolute path for package cache files.
}
\examples{
    rel_files = c("file1.txt", "file2.txt")
    pkg_info = get_pkg_info("mypackage")
    abs_paths = get_absolute_path_for_files(pkg_info, rel_files)

}
