% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-remotes.R
\name{parse_pkg_refs}
\alias{parse_pkg_refs}
\alias{parse_pkg_ref}
\title{Parse package location references}
\usage{
parse_pkg_refs(refs, remote_types = NULL, ...)

parse_pkg_ref(ref, remote_types = NULL, ...)
}
\arguments{
\item{refs}{Character vector of references.}

\item{remote_types}{Custom remote types can be added here, this is
for advanced use, and experimental currently.}

\item{...}{Additional arguments are passed to the individual parser
functions.}

\item{ref}{A package reference, like \code{refs}, but a length one vector,
for convenience.}
}
\value{
\code{parse_pkg_refs()} returns a list of parsed references.
\code{parse_pkg_ref()} returns one parsed reference. A parsed reference is
a list, with at least elements:
\itemize{
\item \code{ref}: The original reference string.
\item \code{type}: The reference type.
\item \code{package}: The package name.
It typically contains additional data, specific to the various
reference types. See \link{pkg_refs} for details.
The parsed reference always has class \verb{remote_ref_<type>} and
\code{remote_ref}.
}
}
\description{
See \link{pkg_refs} for more about supported package references.
}
