% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppm.R
\name{ppm_repo_url}
\alias{ppm_repo_url}
\title{Returns the current Posit Package Manager (PPM) repository URL}
\usage{
ppm_repo_url()
}
\value{
String scalar, the repository URL of the configured PPM
instance. If no PPM instance is configured, then the URL of the Posit
Public Package Manager instance. It includes the repository name, e.g.
\verb{https://packagemanager.posit.co/all}.
}
\description{
Returns the current Posit Package Manager (PPM) repository URL
}
\details{
This URL has the form \code{{base}/{repo}}, e.g.
\verb{https://packagemanager.posit.co/all}.

To configure a hosted PPM instance, set the \code{PKGCACHE_PPM_URL}
environment variable to the base URL (e.g.
\verb{https://packagemanager.posit.co}).

To use \code{\link[=repo_add]{repo_add()}} with PPM snapshots, you may also set the
\code{PKGCACHE_PPM_REPO} environment variable to the name of the default
repository.

On Linux, instead of setting these environment variables, you can also
add a PPM repository to the \code{repos} option, see \code{\link[base:options]{base::options()}}.
If the environment variables are not set, then \code{ppm_repo_url()} will
try to extract the PPM base URL and repository name from this option.

If the \code{PKGCACHE_PPM_URL} environment variable is not set, and the
\code{repos} option does not contain a PPM URL (on Linux), then pkgcache
uses the public PPM instance at \verb{https://packagemanager.posit.co}, with
the \code{cran} repository.
}
\examples{
ppm_repo_url()
}
\seealso{
The 'pkgcache and Posit Package Manager on Linux'
article at \url{https://r-lib.github.io/pkgcache/dev/}.

\code{\link[=repo_resolve]{repo_resolve()}} and \code{\link[=repo_add]{repo_add()}} to find and configure PPM
snapshots.

Other PPM functions: 
\code{\link{ppm_has_binaries}()},
\code{\link{ppm_platforms}()},
\code{\link{ppm_r_versions}()},
\code{\link{ppm_snapshots}()}
}
\concept{PPM functions}
