% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m325tracebw.R
\name{m325tracebw}
\alias{m325tracebw}
\title{Minenergo-325. Trace backwards thermal-hydraulic regime for district heating
 network}
\usage{
m325tracebw(
  sender = 6,
  acceptor = 7,
  temperature = 70,
  pressure = pipenostics::mpa_kgf(6),
  consumption = 20,
  d = 100,
  len = 72.446,
  year = 1986,
  insulation = 0,
  laying = "tunnel",
  beta = FALSE,
  exp5k = TRUE,
  roughness = 0.001,
  inlet = 0.5,
  outlet = 1,
  method = "romeo",
  opinion = "median",
  verbose = TRUE,
  csv = FALSE,
  file = "m325tracebw.csv"
)
}
\arguments{
\item{sender}{identifier of the node which heat carrier flows out.
Type: any type that can be painlessly coerced to character by
\code{\link{as.character}}.}

\item{acceptor}{identifier of the node which heat carrier flows in. According to topology
of test bench considered this identifier should be unique for every row.
Type: any type that can be painlessly coerced to character by
\code{\link{as.character}}.}

\item{temperature}{\emph{snapshot of thermal-hydraulic regime state}: temperature of heat carrier
(water) sensor-measured on the terminal acceptor node, [\emph{°C}].
Use \code{NA_float_}s for nodes without temperature sensor.
Type: \code{\link{assert_double}}.}

\item{pressure}{\emph{snapshot of thermal-hydraulic regime state}: sensor-measured
\href{https://en.wikipedia.org/wiki/Pressure_measurement#Absolute}{absolute pressure}
of heat carrier (water) inside the pipe (i.e. acceptor's incoming edge),
[\emph{MPa}]. Type: \code{\link{assert_double}}.}

\item{consumption}{\emph{snapshot of thermal-hydraulic regime state}:
sensor-measured amount of heat carrier (water) on terminal node that is
transferred by pipe (i.e. acceptor's incoming edge) during a period,
[\emph{ton/hour}]. Type: \code{\link{assert_double}}.
Use \code{NA_float_}s for nodes without consumption sensor.}

\item{d}{internal diameter of pipe (i.e.diameter of acceptor's incoming edge),
[\emph{mm}].
Type: \code{\link{assert_double}}.}

\item{len}{pipe length (i.e. length of acceptor's incoming edge), [\emph{m}].
Type: \code{\link{assert_double}}.}

\item{year}{year when the pipe (i.e. acceptor's incoming edge) is put in operation
after laying or total overhaul.
Type: \code{\link{assert_integerish}}.}

\item{insulation}{identifier of insulation that covers the exterior of pipe (i.e. acceptor's
incoming edge):
 \describe{
   \item{\code{0}}{no insulation}
   \item{\code{1}}{foamed polyurethane or analogue}
   \item{\code{2}}{polymer concrete}
 }
Type: \code{\link{assert_subset}}.}

\item{laying}{type of pipe laying depicting the position of pipe in space. Only five
types of pipe laying are considered:
\itemize{
  \item \code{air},
  \item \code{channel},
  \item \code{room},
  \item \code{tunnel},
  \item \code{underground}.
}
Type: \code{\link{assert_subset}}.}

\item{beta}{logical indicator: should they consider additional heat losses of fittings
located on this pipe (i.e. acceptor's incoming edge)?
Type: \code{\link{assert_logical}}.}

\item{exp5k}{logical indicator for regime of pipe (i.e. acceptor's incoming edge): if
\code{TRUE} pipe is operated more that \code{5000} hours per year.
Type: \code{\link{assert_logical}}.}

\item{roughness}{roughness of internal wall of pipe (i.e. acceptor's incoming edge),
[\emph{m}]. Type: \code{\link{assert_logical}}.}

\item{inlet}{elevation of pipe inlet, [\emph{m}]. Type: \code{\link{assert_double}}.}

\item{outlet}{elevation of pipe outlet, [\emph{m}]. Type: \code{\link{assert_double}}.}

\item{method}{method of determining \emph{Darcy friction factor}:
\itemize{
  \item \code{romeo}
  \item \code{vatankhan}
  \item \code{buzelli}
}
Type: \code{\link{assert_choice}}.
For more details see \code{\link{dropp}}.}

\item{opinion}{method for aggregating values of regime parameters on each node for the
next tracing step:
\describe{
   \item{\code{mean}}{values of parameter are averaged before the next
   tracing step}
   \item{\code{median}}{median of parameter values are used for the next
   tracing step}
 }
Type: \code{\link{assert_choice}}.}

\item{verbose}{logical indicator: should they watch tracing process on console?
Type: \code{\link{assert_flag}}.}

\item{csv}{logical indicator: should they incrementally dump results to \emph{csv}-file
while tracing?
Type: \code{\link{assert_flag}}.}

\item{file}{name of \emph{csv}-file which they dump results to.
Type: \code{\link{assert_character}} of length 1 that can be used safely
to create a file and write to it.}
}
\value{
\code{data.frame} containing results of tracing in
   long format
   (\href{https://en.wikipedia.org/wiki/Wide_and_narrow_data}{narrow format})
   mostly like it returned by function \code{\link{m325tracefw}}:
   \describe{
     \item{\code{node}}{
       identifier of the node for which regime parameters is calculated.
       Values in this vector are identical to those in argument \code{acceptor}.
       Type: \code{\link{assert_character}}.
     }

    \item{\code{trace}}{
      concatenated identifiers of nodes from which regime parameters are
      traced for the given node. Identifier \code{sensor} is used when
      values of regime parameters for the node are sensor readings.
      Type: \code{\link{assert_character}}.
    }

    \item{\code{backward}}{
      identifier of tracing direction. It constantly equals to \code{TRUE}.
      Type: \code{\link{assert_logical}}.
    }

    \item{\code{aggregation}}{
      aggregation method associated with values of calculated temperature or
      pressure in \code{data.frame}'s row for the node:
      \describe{
         \item{\code{identity}}{
           values (opinions) of temperature or pressure as they are
           (no aggregation).
         }
         \item{\code{span}}{
           span of values (opinions) of temperature or pressure for the node
         }
         \item{\code{median}}{
           median of values (opinions) of temperature or pressure for the node
         }
         \item{\code{mean}}{
           avaraged values (opinions) temperature or pressure for the node
         }
      }
      Type: \code{\link{assert_character}}.
    }

   \item{\code{temperature}}{
     \emph{snapshot of thermal-hydraulic regime state}: traced temperature of heat
     carrier (water) that is associated with the node, [\emph{°C}]
     Type: \code{\link{assert_double}}.
   }

   \item{\code{pressure}}{
     \emph{snapshot of thermal-hydraulic regime state}: traced pressure of heat
     carrier (water) that is associated with the node, [\emph{MPa}]
     Type: \code{\link{assert_double}}.
   }

   \item{\code{consumption}}{
     \emph{snapshot of thermal-hydraulic regime state}: traced pressure of heat
     carrier (water) that is associated with the node, [\emph{ton/hour}]
     Type: \code{\link{assert_double}}.
   }

   \item{\code{job}}{
     value of trace step counter.
     Type: \code{\link{assert_integer}}.
   }
 }
}
\description{
Trace values of thermal-hydraulic regime (temperature, pressure,
 consumption) in the bunched pipeline against the flow direction using norms of
 heat flux values prescribed by
 \href{http://docs.cntd.ru/document/902148459}{Minenergo Order 325}.
}
\details{
The calculated (values of) regime may be considered as representation of
 district heating process in conditions of hypothetically perfect
 technical state of pipe walls and insulation.

 They consider the topology of district heating network much similar to
 \code{\link{m325testbench}}:

 \figure{m325tracebw.png}

 Tracing starts from sensor-equipped nodes and goes backwards, i.e against
 the flow direction.

 Though some input arguments are natively vectorized their individual values
 all relate to common part of district heating network, i.e. associated with
 common object. It is due to isomorphism between vector representation and
 directed graph of this network. For more details of isomorphic topology
 description see \code{\link{m325testbench}}.

 Before tracing starts for the next node, previously calculated values of
 temperature or pressure at the node are aggregated by either averaging or
 by median.
 The latter seems more robust for avoiding strong influence of possible
 outliers which may come from actual heating transfer anomalies, erroneous
 sensor readings or wrong pipeline specifications.

 Aggregation for values of consumption at the node is always \code{\link{sum}}.
}
\examples{
# It is possible to run without specification of argument values:
m325tracebw()

# Get isomorphic representation of district heating network graph:
nx <- pipenostics::m325testbench
nx$d <- 1e3*nx$d  # convert [m] to [mm]

# When tracing large network graphs put screen log to file
output <- do.call("m325tracebw", c(as.list(nx), verbose = TRUE))

# Distinct options for opinion aggregation lead to distinct traced
# temperature and pressure:
output <- list(
  mean   = do.call("m325tracebw",
                   c(as.list(nx), verbose = FALSE, opinion = "mean")),
  median = do.call("m325tracebw",
                   c(as.list(nx), verbose = FALSE, opinion = "median"))
)

stopifnot(
  round(
    subset(
      output$mean,
      node == 13 & aggregation == "median",
      c("temperature", "pressure", "consumption")
    ) - subset(
      output$median,
      node == 13 & aggregation == "median",
      c("temperature", "pressure", "consumption")
    ),
    5
    # difference between aggregation options
  ) == c(dt = 0.03732, dp = 0.00139, dg = 0)
)
}
\seealso{
Other Regime tracing: 
\code{\link{m325tracefw}()},
\code{\link{m325traceline}()}
}
\concept{Regime tracing}
