% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin.R
\name{pin}
\alias{pin}
\title{Pin a resource (legacy API)}
\usage{
pin(x, name = NULL, description = NULL, board = NULL, ...)
}
\arguments{
\item{x}{An object, local file or remote URL to pin.}

\item{name}{The name for the dataset or object.}

\item{description}{Optional description for this pin.}

\item{board}{The board where this pin will be placed.}

\item{...}{Additional parameters.}
}
\description{
Pins the given resource locally or to the given board.
}
\details{
\code{pin()} allows you to cache remote resources and intermediate results with ease. When
caching remote resources, usually URLs, it will check for HTTP caching headers to avoid
re-downloading when the remote result has not changed.

This makes it ideal to support reproducible research by requiring manual instruction to
download resources before running your R script.

In addition, \code{pin()} still works when working offline or when the remote resource
becomes unavailable; when this happens, a warning will be triggered but your code will
continue to work.

\code{pin()} stores data frames in two files, an R native file (RDS) and a 'CSV' file. To
force saving a pin in R's native format only, you can use \code{pin(I(data))}.
This can improve performance and size at the cost of making the pin unreadable from other
tools and programming languages.
}
\examples{
# old API
board_register_local(cache = tempfile())
pin(mtcars)
pin_get("mtcars")

# new api
board <- board_local()
board \%>\% pin_write(mtcars)
board \%>\% pin_read("mtcars")

}
