% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin_search.R
\name{pin_search}
\alias{pin_search}
\title{Search for pins}
\usage{
pin_search(board, search = NULL, ...)
}
\arguments{
\item{board}{A pin board, created by \code{\link[=board_folder]{board_folder()}}, \code{\link[=board_rsconnect]{board_rsconnect()}},
\code{\link[=board_url]{board_url()}} or other other \code{board_} function.}

\item{search}{A string to search for in pin name and title.
Use \code{NULL} to return all pins.}

\item{...}{Additional arguments passed on to methods.}
}
\value{
A data frame that summarises the metadata for each pin.
Key attributes (\code{name}, \code{type}, \code{description}, \code{created}, and \code{file_size})
are pulled out into columns; everything else can be found in the \code{meta}
list-column.
}
\description{
The underlying search method depends on the \code{board}, but most will search
for text in the pin name and title.
}
\examples{
board <- board_temp()

board \%>\% pin_write(1:5, "x", title = "Some numbers")
board \%>\% pin_write(letters[c(1, 5, 10, 15, 21)], "y", title = "My favourite letters")
board \%>\% pin_write(runif(20), "z", title = "Random numbers")

board \%>\% pin_search()
board \%>\% pin_search("number")
board \%>\% pin_search("letters")
}
