% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetBettingStatus.R
\name{GetBettingStatus}
\alias{GetBettingStatus}
\title{Check the Pinnacle API's Betting Status}
\usage{
GetBettingStatus()
}
\value{
A string containing the betting status of the API, which should be one of

\itemize{
  \item \code{ALL_BETTING_ENABLED}
  \item \code{ALL_LIVE_BETTING_CLOSED}
  \item \code{ALL_BETTING_CLOSED}
}
}
\description{
Checks whether betting through the API is currently enabled. Betting,
particularly betting on live events, may be closed during maintenance.
}
\details{
This function will raise an error if the API does not return HTTP status
\code{OK}. For information on the possible errors, see the API documentation
for \href{https://pinnacleapi.github.io/betsapi#tag/Betting-Status}{Get Betting Status}.
}
\examples{
\donttest{
SetCredentials("TESTAPI", "APITEST")
AcceptTermsAndConditions(accepted = TRUE)
GetBettingStatus()
}

}
