% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pima-htsreml.r
\name{pima_htsreml}
\alias{pima_htsreml}
\alias{htsreml}
\title{Partlett--Riley prediction interval}
\usage{
pima_htsreml(y, sigma, alpha = 0.05, vartype = c("HK", "SJBC", "CL"),
  maxiter = 100)
}
\arguments{
\item{y}{the effect size estimates vector}

\item{sigma}{the within studies standard errors vector}

\item{alpha}{the alpha level of the prediction interval}

\item{vartype}{the type of the variance estimator for \eqn{\hat{\mu}} (default = "HK"):
\itemize{
\item \code{HK}: the Hartung and Knapp (2001)'s estimator.
\item \code{SJBC}: the Sidik and Jonkman (2006)'s bias coreccted estimator.
\item \code{CL}: a standard estimator, \eqn{(1/\sum{\hat{w}_i})^{-1}}.
}}

\item{maxiter}{the maximum number of iterations}
}
\value{
\itemize{
\item \code{muhat}: the average treatment effect estimate \eqn{\hat{\mu}}.
\item \code{lci}, \code{lci}: the lower and upper confidence limits \eqn{\hat{\mu}_l} and \eqn{\hat{\mu}_u}.
\item \code{lpi}, \code{lpi}: the lower and upper prediction limits \eqn{\hat{c}_l} and \eqn{\hat{c}_u}.
\item \code{tau2h}: the estimate for \eqn{\tau^2}.
}
}
\description{
A subroutine for the Partlett--Riley PI
based on the REML estimator (Partlett & Riley, 2017)
}
\examples{
data(sbp, package = "pimeta")
pimeta::pima_htsreml(sbp$y, sbp$sigmak)
# 
# Prediction Interval for Random-Effects Meta-Analysis
# 
# Partlett-Riley prediction interval
#  Heterogeneity variance: REML
#  SE for average treatment effect: Hartung-Knapp
# 
# Average treatment effect [95\%PI]:
#  -0.3287 [-0.9887, 0.3312]
# 
# Average treatment effect [95\%CI]:
#  -0.3287 [-0.5761, -0.0814]
# 
# Heterogeneity variance (tau^2):
#  0.0700
#
}
\references{
Partlett, C, and Riley, R. D. (2017).
Random effects meta-analysis: Coverage performance of 95%
confidence and prediction intervals following REML estimation.
\emph{Stat Med.}
\strong{36}(2): 301-317.
}
\seealso{
\code{\link[=pima]{pima()}}.
}
