% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicPieceGrob.R
\name{basicPieceGrobs}
\alias{basicPieceGrobs}
\alias{basicPieceGrob}
\alias{picturePieceGrobFn}
\alias{pyramidTopGrob}
\alias{previewLayoutGrob}
\title{Piece Grob Functions}
\usage{
basicPieceGrob(piece_side, suit, rank, cfg = pp_cfg())

picturePieceGrobFn(directory, filename_fn = find_pp_file)

pyramidTopGrob(piece_side, suit, rank, cfg = pp_cfg())

previewLayoutGrob(piece_side, suit, rank, cfg = pp_cfg())
}
\arguments{
\item{piece_side}{A string with piece and side separated by a underscore e.g. "coin_face"}

\item{suit}{Number of suit (starting from 1).}

\item{rank}{Number of rank (starting from 1)}

\item{cfg}{Piecepack configuration list or \code{pp_cfg} object.}

\item{directory}{Directory that \code{picturePieceGrobFn} will look in for piece graphics.}

\item{filename_fn}{Function that takes arguments \code{directory}, \code{piece_side}, \code{suit},
\code{rank}, and optionally \code{cfg} and returns the (full path) filename of the image that the
function returned by \code{picturePieceGrobFn} should import.}
}
\description{
\code{basicPieceGrob}, \code{pyramidTopGrob}, and \code{previewLayoutGrob}
are the default \dQuote{grob} functions that \code{grid.piece} uses
to create \code{grid} graphical \code{grob} objects.  \code{picturePieceGrobFn}
is a function that returns a \dQuote{grob} function that imports graphics from files
found in its \code{directory} argument.
}
\examples{

 if (require("grid") && all(capabilities(c("cairo", "png")))) {
    op <- options()
    on.exit(options(op))
    options(piecepackr.at.inform = FALSE)
    cfg <- pp_cfg(list(invert_colors=TRUE))

    pushViewport(viewport(width=unit(2, "in"), height=unit(2, "in")))
    grid.draw(basicPieceGrob("tile_face", suit=1, rank=3))
    popViewport()

    grid.newpage()
    pushViewport(viewport(width=unit(0.75, "in"), height=unit(0.75, "in")))
    grid.draw(basicPieceGrob("coin_back", suit=2, rank=0, cfg=cfg))
    popViewport()

    grid.newpage()
    pushViewport(viewport(width=unit(6, "in"), height=unit(6, "in")))
    grid.draw(previewLayoutGrob("preview_layout", suit=5, rank=0, cfg=cfg))
    popViewport()

    grid.newpage()
    pushViewport(viewport(width=unit(0.75, "in"), height=unit(0.75, "in")))
    grid.draw(pyramidTopGrob("pyramid_top", suit=3, rank=5))
    popViewport()

    \donttest{
        directory <- tempdir()
        save_piece_images(cfg, directory=directory, format="svg", angle=0)
        cfg2 <- pp_cfg(list(grob_fn=picturePieceGrobFn(directory)))

        grid.newpage()
        pushViewport(viewport(width=unit(0.75, "in"), height=unit(0.75, "in")))
        grid.draw(pyramidTopGrob("pyramid_top", suit=3, rank=5, cfg=cfg2))
        popViewport()
    }
 }
}
