% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce-index.R
\name{as.data.frame.piar_index}
\alias{as.data.frame.piar_index}
\alias{as.matrix.piar_index}
\title{Coerce an index into a tabular form}
\usage{
\method{as.data.frame}{piar_index}(x, ..., stringsAsFactors = FALSE)

\method{as.matrix}{piar_index}(x, ...)
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elemental_index]{elemental_index()}}.}

\item{...}{Further arguments passed to or used by methods.}

\item{stringsAsFactors}{See \code{\link[=as.data.frame]{as.data.frame()}}.}
}
\value{
\code{as.data.frame()} returns a data frame with three columns: \code{period}, \code{level},
and \code{value}.

\code{as.matrix()} returns a matrix with a row for each level and a column
for each period.
}
\description{
Turn an index into a data frame or a matrix.
}
\examples{
prices <- data.frame(
  rel = 1:8,
  period = rep(1:2, each = 4),
  ea = rep(letters[1:2], 4)
)

epr <- with(prices, elemental_index(rel, period, ea))

as.data.frame(epr)
as.matrix(epr)

}
\seealso{
\code{\link[=as_index]{as_index()}} to coerce a matrix/data frame of index values into an index
object.

Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{head.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}()},
\code{\link{merge.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{vcov.aggregate_piar_index}()}
}
\concept{index methods}
