\name{phylocom.phylosor}
\alias{phylocom.phylosor}
\title{
Calculating Phylosor similarity 
}
\description{
This function can be used to calculating phylosor (Phylogenetic Sorenson ) similarity between each pair of places
}
\usage{
phylocom.phylosor(sample.file = "sample", phylo = "phylo")
}

\arguments{
  \item{sample.file}{
Phylocom "Sample" file in the working directory .
}
  \item{phylo}{
The phylo file in the working directory, must be in newick format.
}
}
\details{
This function has been tested for calculating phylosor for very large phylogenies (more than 17000 tips that generated by Phylomatic)
}
\value{
a distance matrix
}
\references{
Bryant, J.A., Lamanna, C., Morlon, H., Kerkhoff, A.J., Enquist, B.J. & Green, J.L. (2008) Microbes on mountainsides: Contrasting elevational patterns of bacterial and plant diversity. Proceedings of the National Academy of Sciences of the United States of America, 105, 11505-11511.

Morlon, H., Schwilk, D.W., Bryant, J.A., Marquet, P.A., Rebelo, A.G., Tauss, C., Bohannan, B.J.M. & Green, J.L. (2011) Spatial patterns of phylogenetic diversity. Ecology Letters, 14, 141-149.

}

\author{
Jinlong Zhang \email{ jinlongzhang01@gmail.com }
}

\seealso{
\code{\link{phylocom.pd}}
}
\examples{

#  Please make sure the Phylocom executable file can 
#  be invoked by console by adding the system path for it.
#  res <- phylocom.phylosor(sample.file = "sample", phylo = "phylo")
#

}

\keyword{ Phylosor }

