% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-get.R
\name{get_nsqs}
\alias{get_nsqs}
\title{Count number of sequences}
\usage{
get_nsqs(phylota, cid)
}
\arguments{
\item{phylota}{Phylota object}

\item{cid}{Cluster ID(s)}
}
\value{
vector
}
\description{
Count the number of sequences in a cluster(s).
}
\examples{
data("cycads")
# count seqs for a random 10 clusters
random_cids <- sample(cycads@cids, 10)
nsqs <- get_nsqs(phylota = cycads, cid = random_cids)
}
\seealso{
Other tools-public: \code{\link{calc_mad}},
  \code{\link{calc_wrdfrq}}, \code{\link{drop_by_rank}},
  \code{\link{drop_clstrs}}, \code{\link{drop_sqs}},
  \code{\link{get_clstr_slot}}, \code{\link{get_ntaxa}},
  \code{\link{get_sq_slot}}, \code{\link{get_stage_times}},
  \code{\link{get_tx_slot}}, \code{\link{get_txids}},
  \code{\link{is_txid_in_clstr}},
  \code{\link{is_txid_in_sq}},
  \code{\link{list_clstrrec_slots}},
  \code{\link{list_ncbi_ranks}},
  \code{\link{list_seqrec_slots}},
  \code{\link{list_taxrec_slots}},
  \code{\link{plot_phylota_pa}},
  \code{\link{plot_phylota_treemap}},
  \code{\link{read_phylota}}, \code{\link{write_sqs}}
}
