% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-drop.R
\name{drop_clstrs}
\alias{drop_clstrs}
\title{Drop cluster records from phylota object}
\usage{
drop_clstrs(phylota, cid)
}
\arguments{
\item{phylota}{Phylota object}

\item{cid}{Cluster ID(s) to be kept}
}
\value{
phylota
}
\description{
Drops all clusters except those
identified by user.
}
\examples{
data("dragonflies")
# specify cids to *keep*
random_cids <- sample(dragonflies@cids, 100)
# drop an entire cluster
nbefore <- length(dragonflies@cids)
dragonflies <- drop_clstrs(phylota = dragonflies, cid = random_cids)
nafter <- length(dragonflies@cids)
# now there are only 100 clusters
(nafter < nbefore)
}
\seealso{
Other tools-public: \code{\link{calc_mad}},
  \code{\link{calc_wrdfrq}}, \code{\link{drop_by_rank}},
  \code{\link{drop_sqs}}, \code{\link{get_clstr_slot}},
  \code{\link{get_nsqs}}, \code{\link{get_ntaxa}},
  \code{\link{get_sq_slot}}, \code{\link{get_stage_times}},
  \code{\link{get_tx_slot}}, \code{\link{get_txids}},
  \code{\link{is_txid_in_clstr}},
  \code{\link{is_txid_in_sq}},
  \code{\link{list_clstrrec_slots}},
  \code{\link{list_ncbi_ranks}},
  \code{\link{list_seqrec_slots}},
  \code{\link{list_taxrec_slots}},
  \code{\link{plot_phylota_pa}},
  \code{\link{plot_phylota_treemap}},
  \code{\link{read_phylota}}, \code{\link{write_sqs}}
}
