% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexcols_rescale.R
\name{hexcols}
\alias{hexcols}
\title{Generate diverging colors in HCL colour space.}
\usage{
hexcols(x)
}
\arguments{
\item{x}{An object of class \code{\link[vegan]{metaMDS}}}
}
\value{
A range of discrete colors differentiating between phyloregions in
terms of their shared relationships.
}
\description{
A function to generate colors in Hue-Chroma-Luminance colour scheme for
mapping phyloregions.
}
\examples{
library(vegan)
data(dune)
c1 <- metaMDS(dune, trace = 0)
hexcols(c1)
plot(c1$points, pch = 21, cex = 7, bg = hexcols(c1), las = 1)
}
\author{
Barnabas H. Daru \email{darunabas@gmail.com}
}
\keyword{phyloregion}
