% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_tree.R
\docType{data}
\name{coord_tree}
\alias{coord_tree}
\alias{CoordTree}
\title{Cartesian coordinates with specialised grid for trees}
\usage{
coord_tree(
  xlim = NULL,
  ylim = NULL,
  expand = TRUE,
  default = FALSE,
  clip = "on"
)
}
\arguments{
\item{xlim, ylim, expand, default, clip}{See \code{ggplot2::coord_cartesian()}}
}
\value{
coord suitable for adding to a plot
}
\description{
This coord is based on the default Cartesian coordinates, but draws the a
filled background in addition to the normal grid lines. The grid is forced
to appear on every integer value within the scale's range.
}
\details{
The appearance of the grid can be controlled with theme elements:
\describe{
\item{\code{phylepic.grid.bar}}{filled grid (\code{element_rect()}).}
\item{\code{phylepic.grid.line}}{grid line (\code{element_line()}).}
\item{\code{phylepic.grid.every}}{grid frequency (\code{integer}). Default for both
\code{phylepic.grid.every.bar} and \code{phylepic.grid.every.stripe}}
\item{\code{phylepic.grid.every.bar}}{grid bar frequency (\code{integer}).
Defaults to 2 to give an alternative striped background}
\item{\code{phylepic.grid.every.stripe}}{grid bar frequency (\code{integer}).
Defaults to 1 so that every tip on a tree has its own line}
}
}
\keyword{datasets}
