% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plant-qq-ratios.r
\name{UVA_UV}
\alias{UVA_UV}
\title{Calculate UVA:UV photon ratio from spectral irradiance.}
\usage{
UVA_UV(spct, std = "ISO", use.cached.mult = FALSE, use.hinges = TRUE)
}
\arguments{
\item{spct}{an object of class "source.spct"}

\item{std}{select which definition of UVB and UV should be used,
defaults to "ISO"}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls}

\item{use.hinges}{logical indicating whether to use hinges to reduce
interpolation errors}
}
\value{
a single numeric nondimensional value giving the UVA:UV photon ratio,
  with name attribute set to the name of the wavebands, with "(q:q)"
  appended.
}
\description{
This function returns the UVA:UV photon ratio of a light source
spectrum.
}
\examples{
UVA_UV(sun.spct)

}
\seealso{
\code{link[photobiologyWavebands]{UVA}},
  \code{link[photobiologyWavebands]{UV}}.
}
