% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.response.R
\name{response}
\alias{response}
\alias{response.default}
\alias{response.response_mspct}
\alias{response.response_spct}
\title{Integrated response}
\usage{
response(spct, w.band, unit.out, quantity, time.unit, wb.trim, use.hinges, ...)

\method{response}{default}(spct, w.band, unit.out, quantity, time.unit, wb.trim,
  use.hinges, ...)

\method{response}{response_spct}(spct, w.band = NULL,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  quantity = "total", time.unit = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...)

\method{response}{response_mspct}(spct, w.band = NULL,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  quantity = "total", time.unit = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...,
  idx = !is.null(names(spct)))
}
\arguments{
\item{spct}{an R object of class "generic_spct"}

\item{w.band}{waveband or list of waveband objects The waveband(s) determine
the region(s) of the spectrum that are summarized}

\item{unit.out}{character Allowed values "energy", and "photon", or its alias
"quantum"}

\item{quantity}{character Allowed values ""}

\item{time.unit}{character or lubridate::duration}

\item{wb.trim}{logical Flag telling if wavebands crossing spectral data boundaries
are trimmed or ignored}

\item{use.hinges}{logical indicating whether to use hinges to reduce
interpolation errors}

\item{...}{other arguments}

\item{idx}{logical whether to add a column with the names of the elements of
spct}
}
\value{
A single numeric value expressed either as a fraction of one or a
  percentage, or a vector of the same length as the list of wave.bands. The
  quantity returned depends on the value of \code{quantity}. Whether it is
  expressed in energy-based or photon-based units depends on \code{unit.out}.
}
\description{
Calculate average photon- or energy-based photo-response.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{response_spct}: Method for response spectra.

\item \code{response_mspct}: Calculates response from a \code{response_mspct}
}}
\note{
The parameter \code{use.hinges} controls speed optimization. The
  defaults should be suitable in mosts cases. Only the range of wavelengths
  in the wavebands is used and all BSWFs are ignored.
}
\seealso{
Other response functions: \code{\link{e_response}},
  \code{\link{q_response}}
}

