% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.irrad.r
\name{e_irrad}
\alias{e_irrad}
\alias{e_irrad.default}
\alias{e_irrad.source_mspct}
\alias{e_irrad.source_spct}
\title{Energy irradiance}
\usage{
e_irrad(spct, w.band, quantity, time.unit, wb.trim, use.cached.mult, use.hinges,
  allow.scaled, ...)

\method{e_irrad}{default}(spct, w.band, quantity, time.unit, wb.trim,
  use.cached.mult, use.hinges, allow.scaled, ...)

\method{e_irrad}{source_spct}(spct, w.band = NULL, quantity = "total",
  time.unit = NULL, wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.cached.mult = getOption("photobiology.use.cached.mult",
  default = FALSE), use.hinges = NULL, allow.scaled = FALSE, ...)

\method{e_irrad}{source_mspct}(spct, w.band = NULL, quantity = "total",
  time.unit = NULL, wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.cached.mult = getOption("photobiology.use.cached.mult",
  default = FALSE), use.hinges = NULL, allow.scaled = FALSE, ...,
  idx = !is.null(names(spct)))
}
\arguments{
\item{spct}{an R object}

\item{w.band}{a list of \code{waveband} objects or a \code{waveband} object}

\item{quantity}{character string}

\item{time.unit}{character or lubridate::duration}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls}

\item{use.hinges}{logical indicating whether to use hinges to reduce
interpolation errors}

\item{allow.scaled}{logical indicating whether scaled or normalized spectra
as argument to spct are flagged as an error}

\item{...}{other arguments (possibly ignored)}

\item{idx}{logical whether to add a column with the names of the elements of
spct}
}
\value{
One numeric value for each waveband with no change in scale factor,
  with name attribute set to the name of each waveband unless a named list is
  supplied in which case the names of the list elements are used. The
  time.unit attribute is copied from the spectrum object to the output. Units
  are as follows: If time.unit is second, [W m-2 nm-1] -> [W m-2] If
  time.unit is day, [J d-1 m-2 nm-1] -> [J m-2]
}
\description{
This function returns the energy irradiance for a given waveband of a light
source spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{source_spct}: Calculates energy irradiance from a \code{source_spct}
object.

\item \code{source_mspct}: Calculates energy irradiance from a
\code{source_mspct} object.
}}
\note{
The last two parameters control speed optimizations. The defaults
  should be suitable in mosts cases. If you will use repeatedly the same SWFs
  on many spectra measured at exactly the same wavelengths you may obtain
  some speed up by setting \code{use.cached.mult=TRUE}. However, be aware
  that you are responsible for ensuring that the wavelengths are the same in
  each call, as the only test done is for the length of the \code{w.length}
  vector.
}
\examples{
e_irrad(sun.spct, waveband(c(400,700)))

}
\seealso{
Other irradiance functions: \code{\link{e_fluence}},
  \code{\link{energy_irradiance}}, \code{\link{fluence}},
  \code{\link{irradiance}}, \code{\link{irrad}},
  \code{\link{photon_irradiance}}, \code{\link{q_fluence}},
  \code{\link{q_irrad}}
}

