% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.class.r
\name{wl_stepsize}
\alias{wl_stepsize}
\alias{stepsize}
\alias{stepsize.default}
\alias{stepsize.numeric}
\alias{stepsize.generic_spct}
\alias{stepsize.generic_mspct}
\title{Stepsize}
\usage{
wl_stepsize(x, ...)

stepsize(x, ...)

\method{stepsize}{default}(x, ...)

\method{stepsize}{numeric}(x, ...)

\method{stepsize}{generic_spct}(x, ...)

\method{stepsize}{generic_mspct}(x, ..., idx = "spct.idx")
}
\arguments{
\item{x}{an R object}

\item{...}{not used in current version}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}
}
\value{
A numeric vector of length 2 with min and maximum stepsize values.
}
\description{
Function that returns the range of step sizes in an object. Range of
differences between successive sorted values.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default function usable on numeric vectors.

\item \code{numeric}: Method for numeric vectors.

\item \code{generic_spct}: Method for "generic_spct" objects.

\item \code{generic_mspct}: Method for "generic_mspct" objects.
}}

\examples{
stepsize(sun.spct)
wl_stepsize(sun.spct)

stepsize(sun.spct)

}
\seealso{
Other wavelength summaries: \code{\link{wl_midpoint}},
  \code{\link{wl_min}}, \code{\link{wl_range}}
}
\concept{wavelength summaries}
