% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbindspct.r
\name{Extract_mspct}
\alias{Extract_mspct}
\alias{[.generic_mspct}
\alias{[<-.generic_mspct}
\alias{$<-.generic_mspct}
\alias{[[<-.generic_mspct}
\title{Extract or replace members of a collection of spectra}
\usage{
\method{[}{generic_mspct}(x, i, drop = NULL)

\method{[}{generic_mspct}(x, i) <- value

\method{$}{generic_mspct}(x, name) <- value

\method{[[}{generic_mspct}(x, name) <- value
}
\arguments{
\item{x}{Collection of spectra object from which to extract member(s) or in
which to replace member(s)}

\item{i}{Index specifying elements to extract or replace. Indices are numeric
or character vectors. Please, see \code{\link[base]{Extract}} for
more details.}

\item{drop}{If TRUE the result is coerced to the lowest possible dimension
(see the examples). This only works for extracting elements, not for the
replacement.}

\item{value}{A suitable replacement value: it will be repeated a whole number
of times if necessary and it may be coerced: see the Coercion section. If
NULL, deletes the column if a single column is selected.}

\item{name}{A literal character string or a name (possibly backtick quoted).
For extraction, this is normally (see under ‘Environments’) partially
matched to the names of the object.}
}
\value{
An object of the same class as \code{x} but containing only the
  subset of members that are selected.
}
\description{
Just like extraction and replacement with indexes for base R lists, but
preserving the special attributes used in spectral classes.
}
\details{
This method is a wrapper on base R's extract method for lists that
  sets additional attributes used by these classes.
}
