% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sun.calc.r
\name{day_night}
\alias{day_night}
\alias{noon_time}
\alias{sunrise_time}
\alias{sunset_time}
\alias{day_length}
\alias{night_length}
\title{Times for sun positions}
\usage{
day_night(date = lubridate::today(), tz = Sys.timezone(),
  geocode = data.frame(lon = 0, lat = 51.5, address = "Greenwich"),
  twilight = "none", unit.out = "hours")

noon_time(date = lubridate::today(), tz = Sys.timezone(),
  geocode = data.frame(lon = 0, lat = 51.5, address = "Greenwich"),
  twilight = "none", unit.out = "datetime")

sunrise_time(date = lubridate::today(), tz = Sys.timezone(),
  geocode = data.frame(lon = 0, lat = 51.5, address = "Greenwich"),
  twilight = "sunlight", unit.out = "datetime")

sunset_time(date = lubridate::today(), tz = Sys.timezone(),
  geocode = data.frame(lon = 0, lat = 51.5, address = "Greenwich"),
  twilight = "sunlight", unit.out = "datetime")

day_length(date = lubridate::today(), tz = "UTC", geocode = data.frame(lon
  = 0, lat = 51.5, address = "Greenwich"), twilight = "sunlight",
  unit.out = "hours")

night_length(date = lubridate::today(), tz = "UTC",
  geocode = data.frame(lon = 0, lat = 51.5, address = "Greenwich"),
  twilight = "sunlight", unit.out = "hours")
}
\arguments{
\item{date}{vector of POSIXct times or Date objects, any valid TZ is allowed,
default is current date}

\item{tz}{vector of character string indicating time zone to be used in output.}

\item{geocode}{data frame with one or more rows and variables lon and lat as
numeric values (degrees).}

\item{twilight}{character string, one of "none", "civil", "nautical",
"astronomical", or a \code{numeric} vector of length one, or two, giving
solar elevation angle(s) in degrees (negative if below the horizon).}

\item{unit.out}{charater string, One of "datetime", "hour", "minute", or "second".}
}
\value{
A data.fraame with variables day, tz, twilight.rise, twilight.set,
  longitude, latitude, address, sunrise, noon, sunset, daylength,
  nightlength.

\code{noon_time}, \code{sunrise_time} and \code{sunset_time} return a
  vector of POSIXct times

\code{day_length} and \code{night_length} return numeric a vector
  giving the length in hours
}
\description{
Functions for calculating the timing of solar positions by means of function
\code{sun_angles}, given geographical coordinates and dates. They can be also
used to find the time for an arbitrary solar elevation between 90 and -90
degrees by supplying "twilight" angle(s) as argument.
}
\details{
Twilight names are interpreted as follows. "none": solar elevation =
  0 degrees. "refraction": solar elevation = 0 degrees + refraction
  correction. "sunlight": upper rim of solar disk corrected for refraction.
  "civil": -6 degrees, "naval": -12 degrees, and "astronomical": -18 degrees.
  Unit names for output are as follows: "hours" times for sunrise and sunset
  are returned as times-of-day in hours since middnight. "date" or "datetime"
  return the same times as datetime objects with TZ set (this is much slower
  the "hours"). Day length and night length are always returned as numeric
  values expressed in hours.
}
\note{
If twilight is a numeric vector of length two, the element with index 1
  is used for sunrise and that with index 2 for sunset.

\code{night_length} returns the length of night-time conditions in one
  day (00:00:00 to 23:59:59), rather than the length of the night between two
  consequtive days.
}
\examples{
library(lubridate)
my.geocode <- data.frame(lat = 60, lon = 25)
day_night(ymd("2015-05-30"), geocode = my.geocode, twilight = "civil")

}
\seealso{
Other astronomy related functions: \code{\link{format.solar_time}},
  \code{\link{is.solar_time}},
  \code{\link{print.solar_time}}, \code{\link{solar_time}},
  \code{\link{sun_angles}}
}
