% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.operators.r
\name{round}
\alias{round}
\alias{round.generic_spct}
\alias{signif.generic_spct}
\alias{ceiling.generic_spct}
\alias{floor.generic_spct}
\alias{trunc.generic_spct}
\title{Rounding of Numbers}
\usage{
\method{round}{generic_spct}(x, digits = 0)

\method{signif}{generic_spct}(x, digits = 6)

\method{ceiling}{generic_spct}(x)

\method{floor}{generic_spct}(x)

\method{trunc}{generic_spct}(x, ...)
}
\arguments{
\item{x}{an object of class "generic_spct" or a derived class.}

\item{digits}{integer indicating the number of decimal places (round) or
significant digits (signif) to be used. Negative values are allowed (see
'Details').}

\item{...}{arguments to be passed to methods.}
}
\description{
\code{ceiling} takes a single numeric argument x and returns a numeric vector
containing the smallest integers not less than the corresponding elements of
x. \\
\code{floor} takes a single numeric argument x and returns a numeric vector
containing the largest integers not greater than the corresponding elements
of x. \\
\code{trunc} takes a single numeric argument x and returns a numeric vector
containing the integers formed by truncating the values in x toward 0. \\
\code{round} rounds the values in its first argument to the specified number of
decimal places (default 0). \\
\code{signif} rounds the values in its first argument to the specified number of
significant digits. \\
The functions are applied to the spectral data, not the wavelengths. The
quantity in the spectrum to which the function is applied depends on the class
of \code{x} and the current value of output options.
}
\seealso{
Other math operators and functions: 
\code{\link{MathFun}},
\code{\link{^.generic_spct}()},
\code{\link{convolve_each}()},
\code{\link{div-.generic_spct}},
\code{\link{log}()},
\code{\link{minus-.generic_spct}},
\code{\link{mod-.generic_spct}},
\code{\link{plus-.generic_spct}},
\code{\link{sign}()},
\code{\link{slash-.generic_spct}},
\code{\link{times-.generic_spct}}
}
\concept{math operators and functions}
