% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaf.data.R
\docType{data}
\name{Ler_leaf.spct}
\alias{Ler_leaf.spct}
\alias{Ler_leaf_rflt.spct}
\alias{Ler_leaf_trns.spct}
\alias{Ler_leaf_trns_i.spct}
\title{Green Arabidopsis leaf reflectance and transmittance.}
\format{
Datasets stored as \code{object_spct}, \code{reflector_spct} and
   \code{filter_spct} objects, containing transmittance and reflectance
   data.

An object of class \code{reflector_spct} (inherits from \code{generic_spct}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 1750 rows and 2 columns.

An object of class \code{filter_spct} (inherits from \code{generic_spct}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 1753 rows and 2 columns.

An object of class \code{filter_spct} (inherits from \code{generic_spct}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 2401 rows and 3 columns.
}
\usage{
Ler_leaf.spct

Ler_leaf_rflt.spct

Ler_leaf_trns.spct

Ler_leaf_trns_i.spct
}
\description{
A dataset of total spectral reflectance and total spectral
  transmittance expressed as fractions of one from the upper surface of a
  leaf of an Arabidopsis thaliana 'Ler' rosette.
}
\details{
\itemize{ \item w.length (nm) \item Rfr (0..1) \item Tfr (0..1)}
}
\note{
Measured with a Jaz spectrometer from Ocean Optics (USA) configured
  with a PX Xenon lamp module and Spectroclip double integrating spheres.
}
\examples{
Ler_leaf.spct
Ler_leaf_rflt.spct

}
\seealso{
Other Spectral data examples: 
\code{\link{A.illuminant.spct}},
\code{\link{D65.illuminant.spct}},
\code{\link{black_body.spct}},
\code{\link{ccd.spct}},
\code{\link{clear.spct}},
\code{\link{filter_cps.mspct}},
\code{\link{green_leaf.spct}},
\code{\link{phenylalanine.spct}},
\code{\link{photodiode.spct}},
\code{\link{sun.spct}},
\code{\link{sun_daily.spct}},
\code{\link{sun_evening.spct}},
\code{\link{two_filters.spct}},
\code{\link{water.spct}},
\code{\link{white_led.source_spct}}
}
\author{
Aphalo, P. J. & Wang, F (unpublished data)
}
\concept{Spectral data examples}
\keyword{datasets}
