% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.peaks.r
\name{wls_at_target}
\alias{wls_at_target}
\alias{wls_at_target.default}
\alias{wls_at_target.data.frame}
\alias{wls_at_target.generic_spct}
\alias{wls_at_target.source_spct}
\alias{wls_at_target.response_spct}
\alias{wls_at_target.filter_spct}
\alias{wls_at_target.reflector_spct}
\alias{wls_at_target.solute_spct}
\alias{wls_at_target.cps_spct}
\alias{wls_at_target.generic_mspct}
\title{Find wavelengths values corresponding to a target spectral value}
\usage{
wls_at_target(
  x,
  target = NULL,
  interpolate = FALSE,
  idfactor = length(target) > 1,
  na.rm = FALSE,
  ...
)

\method{wls_at_target}{default}(
  x,
  target = NULL,
  interpolate = FALSE,
  idfactor = length(target) > 1,
  na.rm = FALSE,
  ...
)

\method{wls_at_target}{data.frame}(
  x,
  target = "0.5max",
  interpolate = FALSE,
  idfactor = length(target) > 1,
  na.rm = FALSE,
  x.var.name = NULL,
  y.var.name = NULL,
  ...
)

\method{wls_at_target}{generic_spct}(
  x,
  target = "0.5max",
  interpolate = FALSE,
  idfactor = length(target) > 1,
  na.rm = FALSE,
  col.name = NULL,
  y.var.name = col.name,
  ...
)

\method{wls_at_target}{source_spct}(
  x,
  target = "0.5max",
  interpolate = FALSE,
  idfactor = length(target) > 1,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...
)

\method{wls_at_target}{response_spct}(
  x,
  target = "0.5max",
  interpolate = FALSE,
  idfactor = length(target) > 1,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...
)

\method{wls_at_target}{filter_spct}(
  x,
  target = "0.5max",
  interpolate = FALSE,
  idfactor = length(target) > 1,
  na.rm = FALSE,
  filter.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  ...
)

\method{wls_at_target}{reflector_spct}(
  x,
  target = "0.5max",
  interpolate = FALSE,
  idfactor = length(target) > 1,
  na.rm = FALSE,
  ...
)

\method{wls_at_target}{solute_spct}(
  x,
  target = "0.5max",
  interpolate = FALSE,
  idfactor = length(target) > 1,
  na.rm = FALSE,
  ...
)

\method{wls_at_target}{cps_spct}(
  x,
  target = "0.5max",
  interpolate = FALSE,
  idfactor = length(target) > 1,
  na.rm = FALSE,
  ...
)

\method{wls_at_target}{generic_mspct}(
  x,
  target = "0.5max",
  interpolate = FALSE,
  idfactor = length(target) > 1,
  na.rm = FALSE,
  ...,
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{x}{data.frame or spectrum object.}

\item{target}{numeric or character vector. A numeric value indicates the spectral
quantity value for which wavelengths are to be searched. A character
string representing a number is converted to numeric. A character value
representing a number followed by a function name, will be also accepted
and decoded, such that \code{"0.1max"} is interpreted as targeting one
tenth of the maximum value in the column. The character
strings "half.maximum" and "HM" are synonyms for "0.5max" while
"half.range" and "HR" are synonyms for "0.5range".}

\item{interpolate}{logical Indicating whether the nearest wavelength value
in \code{x} should be returned or a value calculated by linear
interpolation between wavelength values straddling the target.}

\item{idfactor}{logical or character Generates an index column of factor
type. If \code{idfactor = TRUE} then the column is auto named target.idx.
Alternatively the column name can be directly passed as argument to
\code{idfactor} as a character string.}

\item{na.rm}{logical indicating whether \code{NA} values should be stripped
before searching for the target.}

\item{...}{currently ignored.}

\item{x.var.name, y.var.name, col.name}{character The name of the columns in
which to search for the target value. Use of \code{col.name} is deprecated,
and is a synonym for \code{y.var.name}.}

\item{unit.out}{character One of "energy" or "photon"}

\item{filter.qty}{character One of "transmittance" or "absorbance"}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A data.frame, a spectrum object or a collection of spectra object of
  the same class as \code{x} with fewer rows, possibly even no rows. If
  \code{FALSE} is passed to \code{interpolate} a subset of \code{x} is
  returned, otherwise a new object of the same class containing interpolated
  wavelengths for the \code{target} value is returned. As `target` accepts
  a vector or list as argument, a factor can be added to the output with
  the corresponding target value.
}
\description{
Find wavelength values corresponding to a target spectral value in a spectrum.
The name of the column of the spectral data to be used is inferred from the
class of \code{x} and the argument passed to \code{unit.out} or
\code{filter.qty} or their defaults that depend on R options set.
}
\section{Methods (by class)}{
\itemize{
\item \code{wls_at_target(default)}: Default returning always an empty object of the
same class as \code{x}.

\item \code{wls_at_target(data.frame)}: Method for "data.frame" objects.

\item \code{wls_at_target(generic_spct)}: Method for "generic_spct" objects.

\item \code{wls_at_target(source_spct)}: Method for "source_spct" objects.

\item \code{wls_at_target(response_spct)}: Method for "response_spct" objects.

\item \code{wls_at_target(filter_spct)}: Method for "filter_spct" objects.

\item \code{wls_at_target(reflector_spct)}: Method for "reflector_spct" objects.

\item \code{wls_at_target(solute_spct)}: Method for "solute_spct" objects.

\item \code{wls_at_target(cps_spct)}: Method for "cps_spct" objects.

\item \code{wls_at_target(generic_mspct)}: Method for "generic_mspct" objects.

}}
\note{
When interpolation is used, only column \code{w.length} and the column
  against which the target value was compared are included in the returned
  object, otherwise, all columns in \code{x} are returned. We implement
  support for \code{data.frame} to simplify the coding of 'ggplot2' stats
  using this function.
}
\examples{
wls_at_target(sun.spct, target = 0.1)
wls_at_target(sun.spct, target = 2e-6, unit.out = "photon")
wls_at_target(polyester.spct, target = "HM")
wls_at_target(polyester.spct, target = "HM", interpolate = TRUE)
wls_at_target(polyester.spct, target = "HM", idfactor = "target")
wls_at_target(polyester.spct, target = "HM", filter.qty = "absorbance")

}
\seealso{
Other peaks and valleys functions: 
\code{\link{find_peaks}()},
\code{\link{find_spikes}()},
\code{\link{get_peaks}()},
\code{\link{peaks}()},
\code{\link{replace_bad_pixs}()},
\code{\link{spikes}()},
\code{\link{valleys}()}
}
\concept{peaks and valleys functions}
