% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.var.r
\name{s_var}
\alias{s_var}
\alias{s_var.default}
\alias{s_var.filter_mspct}
\alias{s_var.source_mspct}
\alias{s_var.response_mspct}
\alias{s_var.reflector_mspct}
\alias{s_var.calibration_mspct}
\alias{s_var.cps_mspct}
\alias{s_var.raw_mspct}
\title{Variance of a collection of spectra}
\usage{
s_var(x, na.rm, ...)

\method{s_var}{default}(x, na.rm = FALSE, ...)

\method{s_var}{filter_mspct}(x, na.rm = FALSE, ...)

\method{s_var}{source_mspct}(x, na.rm = FALSE, ...)

\method{s_var}{response_mspct}(x, na.rm = FALSE, ...)

\method{s_var}{reflector_mspct}(x, na.rm = FALSE, ...)

\method{s_var}{calibration_mspct}(x, na.rm = FALSE, ...)

\method{s_var}{cps_mspct}(x, na.rm = FALSE, ...)

\method{s_var}{raw_mspct}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An R object. Currently this package defines methods for collections
of spectral objects.}

\item{na.rm}{logical. A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  "filter_mspct" object, the returned object is of class "generic_spct",
  containing the variance among the spectra at each wavelength
  in a column with name ending in ".var".
}
\description{
A method to compute the variance of values across members of a collections of
spectra. Computes the variance at each wavelength across all the spectra in
the collection returning a spectral object.
}
\details{
Variance method for collections of spectra. Computes the variance at each
wavelength across all the spectra in the collection.
}
\section{Methods (by class)}{
\itemize{
\item \code{s_var(default)}: 

\item \code{s_var(filter_mspct)}: 

\item \code{s_var(source_mspct)}: 

\item \code{s_var(response_mspct)}: 

\item \code{s_var(reflector_mspct)}: 

\item \code{s_var(calibration_mspct)}: 

\item \code{s_var(cps_mspct)}: 

\item \code{s_var(raw_mspct)}: 

}}
\note{
Omission of NAs is done separately at each wavelength. Interpolation is
  not applied, so all spectra in \code{x} must share the same set of
  wavelengths.

  Objects of classes raw_spct and cps_spct can contain data from multiple
  scans. This functions are implemented for these classes only for the case
  when all member spectra contain data for a single scan, or spliced into a
  single column in the case of cps_spct members.
}
\seealso{
See \code{\link[stats]{cor}} for details about \code{var()}, which
  is used for the computations.
}
