% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{setTimeUnit}
\alias{setTimeUnit}
\title{Set the "time.unit" attribute of an existing source_spct object}
\usage{
setTimeUnit(
  x,
  time.unit = c("second", "hour", "day", "exposure", "none"),
  override.ok = FALSE
)
}
\arguments{
\item{x}{a source_spct object}

\item{time.unit}{a character string, either "second", "hour", "day",
"exposure" or "none", or a lubridate::duration}

\item{override.ok}{logical Flag that can be used to silence warning when
overwriting an existing attribute value (used internally)}
}
\value{
x
}
\description{
Function to set by reference the "time.unit" attribute
}
\note{
This function alters x itself by reference and in addition
  returns x invisibly. If x is not a source_spct or response_spct object, x is not modified.
  The behaviour of this function is 'unusual' in that the default for
  parameter \code{time.unit} is used only if \code{x} does not already have
  this attribute set. \code{time.unit = "hour"} is currently not fully
  supported.
}
\examples{
my.spct <- sun.spct
setTimeUnit(my.spct, time.unit = "second")
setTimeUnit(my.spct, time.unit = lubridate::duration(1, "seconds"))

}
\seealso{
Other time attribute functions: 
\code{\link{checkTimeUnit}()},
\code{\link{convertTimeUnit}()},
\code{\link{getTimeUnit}()}
}
\concept{time attribute functions}
