% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{setBSWFUsed}
\alias{setBSWFUsed}
\title{Set the "bswf.used" attribute}
\usage{
setBSWFUsed(x, bswf.used = c("none", "unknown"))
}
\arguments{
\item{x}{a source_spct object}

\item{bswf.used}{a character string, either "none" or the name of a BSWF}
}
\value{
x
}
\description{
Function to set by reference the "time.unit" attribute of an existing
source_spct object
}
\note{
This function alters x itself by reference and in addition
  returns x invisibly. If x is not a source_spct, x is not modified. The behaviour of this
  function is 'unusual' in that the default for parameter \code{bswf.used} is
  used only if \code{x} does not already have this attribute set.
  \code{time.unit = "hour"} is currently not fully supported.
}
\seealso{
Other BSWF attribute functions: 
\code{\link{getBSWFUsed}()}
}
\concept{BSWF attribute functions}
