% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.peaks.r
\name{peaks}
\alias{peaks}
\alias{peaks.default}
\alias{peaks.numeric}
\alias{peaks.data.frame}
\alias{peaks.generic_spct}
\alias{peaks.source_spct}
\alias{peaks.response_spct}
\alias{peaks.filter_spct}
\alias{peaks.reflector_spct}
\alias{peaks.cps_spct}
\alias{peaks.raw_spct}
\alias{peaks.generic_mspct}
\alias{peaks.source_mspct}
\alias{peaks.response_mspct}
\alias{peaks.filter_mspct}
\alias{peaks.reflector_mspct}
\alias{peaks.cps_mspct}
\alias{peaks.raw_mspct}
\title{Peaks or local maxima}
\usage{
peaks(x, span, ignore_threshold, strict, na.rm, ...)

\method{peaks}{default}(x, span = NA, ignore_threshold = NA, strict = NA, na.rm = FALSE, ...)

\method{peaks}{numeric}(x, span = 5, ignore_threshold = NA, strict = TRUE, na.rm = FALSE, ...)

\method{peaks}{data.frame}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  x.var.name = NULL,
  y.var.name = NULL,
  var.name = y.var.name,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{generic_spct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  var.name = NULL,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{source_spct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{response_spct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{filter_spct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  filter.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{reflector_spct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{cps_spct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  var.name = "cps",
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{raw_spct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  var.name = "counts",
  refine.wl = FALSE,
  method = "spline",
  ...
)

\method{peaks}{generic_mspct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  var.name = NULL,
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{peaks}{source_mspct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{peaks}{response_mspct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{peaks}{filter_mspct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  filter.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{peaks}{reflector_mspct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{peaks}{cps_mspct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  var.name = "cps",
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{peaks}{raw_mspct}(
  x,
  span = 5,
  ignore_threshold = 0,
  strict = TRUE,
  na.rm = FALSE,
  var.name = "counts",
  refine.wl = FALSE,
  method = "spline",
  ...,
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{x}{an R object}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width \code{span} centered at
that element. Use \code{NULL} for the global peak.}

\item{ignore_threshold}{numeric value between 0.0 and 1.0 indicating the
relative size compared to tallest peak threshold below which peaks will be
ignored.}

\item{strict}{logical flag: if TRUE, an element must be strictly greater than
all other values in its window to be considered a peak. Default: TRUE.}

\item{na.rm}{logical indicating whether \code{NA} values should be stripped
before searching for peaks.}

\item{...}{ignored}

\item{var.name, x.var.name, y.var.name}{character Name of column where to look
for peaks.}

\item{refine.wl}{logical Flag indicating if peak location should be refined by
fitting a function.}

\item{method}{character String with the name of a method. Currently only
spline interpolation is implemented.}

\item{unit.out}{character One of "energy" or "photon"}

\item{filter.qty}{character One of "transmittance" or "absorbance"}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A subset of \code{x} with rows corresponding to local maxima.
}
\description{
Function that returns a subset of an R object with observations corresponding
to local maxima.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default returning always NA.

\item \code{numeric}: Default function usable on numeric vectors.

\item \code{data.frame}: Method for "data.frame" objects.

\item \code{generic_spct}: Method for "generic_spct" objects.

\item \code{source_spct}: Method for "source_spct" objects.

\item \code{response_spct}: Method for "response_spct" objects.

\item \code{filter_spct}: Method for "filter_spct" objects.

\item \code{reflector_spct}: Method for "reflector_spct" objects.

\item \code{cps_spct}: Method for "cps_spct" objects.

\item \code{raw_spct}: Method for "raw_spct" objects.

\item \code{generic_mspct}: Method for "generic_mspct" objects.

\item \code{source_mspct}: Method for "source_mspct" objects.

\item \code{response_mspct}: Method for "cps_mspct" objects.

\item \code{filter_mspct}: Method for "filter_mspct" objects.

\item \code{reflector_mspct}: Method for "reflector_mspct" objects.

\item \code{cps_mspct}: Method for "cps_mspct" objects.

\item \code{raw_mspct}: Method for "raw_mspct" objects.
}}

\examples{
peaks(sun.spct, span = 51)
peaks(sun.spct, span = NULL)
peaks(sun.spct, span = 51, refine.wl = TRUE)

peaks(sun.spct)

}
\seealso{
Other peaks and valleys functions: 
\code{\link{find_peaks}()},
\code{\link{find_spikes}()},
\code{\link{get_peaks}()},
\code{\link{replace_bad_pixs}()},
\code{\link{spikes}()},
\code{\link{valleys}()},
\code{\link{wls_at_target}()}
}
\concept{peaks and valleys functions}
