% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phonex.R
\name{phonex}
\alias{phonex}
\title{Phonex Name Coding}
\usage{
phonex(word, maxCodeLen = 4, clean = TRUE)
}
\arguments{
\item{word}{string or vector of strings to encode}

\item{maxCodeLen}{maximum length of the resulting encodings, in characters}

\item{clean}{if \code{TRUE}, return \code{NA} for unknown alphabetical characters}
}
\value{
the Phonex encoded character vector
}
\description{
The Phonex name coding procedure.
}
\details{
The variable \code{word} is the name to be encoded.  The variable
\code{maxCodeLen} is the limit on how long the returned name code
should be.  The default is 4.

The \code{phonex} algorithm is only defined for inputs over the
standard English alphabet, \emph{i.e.}, "A-Z," "Ä," "Ö," "Ü," and
"ß." Non-alphabetical characters are removed from the string in a
locale-dependent fashion.  This strips spaces, hyphens, and numbers.
Other letters, such as "ç," may be permissible in the current locale
but are unknown to \code{phonex}.  For inputs outside of its known
range, the output is undefined and \code{NA} is returned and a
\code{warning} this thrown.  If \code{clean} is \code{FALSE},
\code{phonex} attempts to process the strings.  The default is
\code{TRUE}.
}
\examples{
phonex("William")
phonex(c("Peter", "Peady"))
phonex("Stevenson", maxCodeLen = 8)

}
\references{
James P. Howard, II, "Phonetic Spelling Algorithm Implementations
for R," \emph{Journal of Statistical Software}, vol. 25, no. 8,
(2020), p. 1--21, <10.18637/jss.v095.i08>.

A.J. Lait and Brian Randell. "An assessment of name matching
algorithms." Technical Report Series-University of Newcastle Upon
Tyne Computing Science (1996).
}
\seealso{
Other phonics: 
\code{\link{caverphone}()},
\code{\link{cologne}()},
\code{\link{lein}()},
\code{\link{metaphone}()},
\code{\link{mra_encode}()},
\code{\link{nysiis}()},
\code{\link{onca}()},
\code{\link{phonics}()},
\code{\link{rogerroot}()},
\code{\link{soundex}()},
\code{\link{statcan}()}
}
\concept{phonics}
