#' Result of the fit of Leatherback nest counts from Gratiot et al. (2006) Figure 1
#' @title Result of the fit of Leatherback nest counts
#' @author Marc Girondot \email{marc.girondot@@u-psud.fr}
#' @docType data
#' @name result_Gratiot_Flat
#' @description Result of the fit of Leatherback nest counts from Gratiot et al. (2006) Figure 1.
#' The phenology has been fitted with MinE, MinB, Max, LengthB, LengthE, Peak, Theta.
#' The Flat parameter is set to 0 and is not fitted.
#' @references Gratiot, N., Gratiot, J., de Thoisy, B. & Kelle, L. 2006. 
#'             Estimation of marine turtles nesting season from incomplete 
#'             data ; statistical adjustment of a sinusoidal function. Animal 
#'             Conservation, 9, 95-102.
#' @keywords datasets
#' @usage result_Gratiot_Flat
#' @examples
#' library(phenology)
#' # Read a file with result
#' data(result_Gratiot_Flat)
#' @format A list with Gratiot data and the result of the fit.
NULL
