% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhenoTrs.R
\name{PhenoTrs}
\alias{PhenoTrs}
\alias{PhenoTrs.fFIT}
\alias{PhenoTrs.default}
\title{Phenology extraction in Threshold method (TRS)}
\usage{
PhenoTrs(
  x,
  t = NULL,
  approach = c("White", "Trs"),
  trs = 0.5,
  asymmetric = TRUE,
  IsPlot = TRUE,
  ...
)

\method{PhenoTrs}{fFIT}(x, t = NULL, ...)

\method{PhenoTrs}{default}(
  x,
  t = NULL,
  approach = c("White", "Trs"),
  trs = 0.5,
  asymmetric = TRUE,
  IsPlot = TRUE,
  ...
)
}
\arguments{
\item{x}{numeric vector, or \code{fFIT} object returned by \code{\link[=curvefit]{curvefit()}}.}

\item{t}{\code{doy} vector, corresponding doy of vegetation index.}

\item{approach}{to be used to calculate phenology metrics.
'White' (White et al. 1997) or 'Trs' for simple threshold.}

\item{trs}{threshold to be used for approach "Trs", in (0, 1).}

\item{asymmetric}{If true, background value in spring season and autumn season
is regarded as different.}

\item{IsPlot}{whether to plot?}

\item{...}{other parameters to PhenoPlot}
}
\description{
Phenology extraction in Threshold method (TRS)
}
\examples{
# `doubleLog.Beck` simulate vegetation time-series
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
par  = c( mn  = 0.1 , mx  = 0.7 , sos = 50 , rsp = 0.1 , eos = 250, rau = 0.1)
y <- doubleLog.Beck(par, t)

methods <- c("AG", "Beck", "Elmore", "Gu", "Zhang") # "Klos" too slow
fit <- curvefit(y, t, tout, methods)
x <- fit$model$AG # one model

par(mfrow = c(2, 2))
PhenoTrs(x)
PhenoDeriv(x)
PhenoGu(x)
PhenoKl(x)
}
\seealso{
\code{\link[=PhenoDeriv]{PhenoDeriv()}}, \code{\link[=PhenoGu]{PhenoGu()}}, \code{\link[=PhenoKl]{PhenoKl()}}
}
