% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{evaluate_population_prediction}
\alias{evaluate_population_prediction}
\title{evaluate_population_prediction}
\usage{
evaluate_population_prediction(model, parameters = NULL, dataset = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{parameters}{(list(str=numeric) (optional)) Optional list of parameters and values}

\item{dataset}{(data.frame (optional)) Optional dataset}
}
\value{
(data.frame) Population predictions
}
\description{
Evaluate the numeric population prediction

The prediction is evaluated at the current model parameter values
or optionally at the given parameter values.
The evaluation is done for each data record in the model dataset
or optionally using the dataset argument.

This function currently only support models without ODE systems
}
\examples{
\dontrun{
model <- load_example_model("pheno_linear")
results <- load_example_modelfit_results("pheno_linear")
pe <- results$parameter_estimates
evaluate_population_prediction(model, parameters=list(pe))
}
}
\seealso{
evaluate_individual_prediction : Evaluate the individual prediction
}
