/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.outputdevices;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Locale;
import net.sf.eps2pgf.Main;
import net.sf.eps2pgf.Options;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.io.images.EpsImageCreator;
import net.sf.eps2pgf.io.images.PdfImageCreator;
import net.sf.eps2pgf.ps.Closepath;
import net.sf.eps2pgf.ps.Curveto;
import net.sf.eps2pgf.ps.GraphicsState;
import net.sf.eps2pgf.ps.Image;
import net.sf.eps2pgf.ps.Lineto;
import net.sf.eps2pgf.ps.Moveto;
import net.sf.eps2pgf.ps.Path;
import net.sf.eps2pgf.ps.PathSection;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorIOError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectInt;
import net.sf.eps2pgf.ps.objects.PSObjectMatrix;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.objects.PSObjectReal;
import net.sf.eps2pgf.ps.objects.PSObjectString;
import net.sf.eps2pgf.ps.resources.colors.PSColor;
import net.sf.eps2pgf.ps.resources.outputdevices.OutputDevice;
import net.sf.eps2pgf.ps.resources.shadings.RadialShading;
import net.sf.eps2pgf.ps.resources.shadings.Shading;

public class PGFDevice
implements OutputDevice {
    static final DecimalFormat COOR_FORMAT = new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.US));
    static final DecimalFormat LENGTH_FORMAT = new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.US));
    static final DecimalFormat FONTSIZE_FORMAT = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.US));
    static final DecimalFormat COLOR_FORMAT = new DecimalFormat("#.######", new DecimalFormatSymbols(Locale.US));
    private PSObjectDict scopeStatus;
    static final PSObjectName KEY_LAST_COLOR = new PSObjectName("/lastcolor");
    static final PSObjectName KEY_LAST_LINEWIDTH = new PSObjectName("/lastlinewidth");
    static final PSObjectName KEY_LAST_DASHPATTERN = new PSObjectName("/lastdashpattern");
    static final PSObjectName KEY_LAST_DASHOFFSET = new PSObjectName("/lastdashpattern");
    static final PSObjectName KEY_LAST_LINECAP = new PSObjectName("/lastlinecap");
    static final PSObjectName KEY_LAST_LINEJOIN = new PSObjectName("/lastlinejoin");
    static final PSObjectName KEY_LAST_MITERLIMIT = new PSObjectName("/lastmiterlimit");
    static final PSObjectName KEY_LAST_COLSPACE = new PSObjectName("/lastcolorspace");
    private PSObjectDict deviceStatus;
    static final PSObjectName KEY_SCOPE_DEPTH = new PSObjectName("/scopedepth");
    private Writer out;
    private Options options;
    private int nextImage = 1;

    public PGFDevice(Writer writer, Options options) {
        this.out = writer;
        this.scopeStatus = new PSObjectDict();
        this.deviceStatus = new PSObjectDict();
        this.options = options;
    }

    public PSObjectMatrix defaultCTM() {
        return new PSObjectMatrix(352.77777777777777, 0.0, 0.0, 352.77777777777777, 0.0, 0.0);
    }

    public double[] eps2pgfGetMetrics() {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        return dArray;
    }

    public void init() throws PSError, IOException {
        this.scopeStatus.setKey((PSObject)KEY_LAST_LINEWIDTH, (PSObject)new PSObjectReal(-1.0));
        this.scopeStatus.setKey((PSObject)KEY_LAST_DASHPATTERN, (PSObject)new PSObjectArray());
        this.scopeStatus.setKey((PSObject)KEY_LAST_DASHOFFSET, (PSObject)new PSObjectReal(0.0));
        this.scopeStatus.setKey((PSObject)KEY_LAST_COLOR, (PSObject)new PSObjectArray());
        this.scopeStatus.setKey((PSObject)KEY_LAST_COLSPACE, (PSObject)new PSObjectString(""));
        this.scopeStatus.setKey((PSObject)KEY_LAST_LINECAP, (PSObject)new PSObjectInt(0));
        this.scopeStatus.setKey((PSObject)KEY_LAST_LINEJOIN, (PSObject)new PSObjectInt(0));
        this.scopeStatus.setKey((PSObject)KEY_LAST_MITERLIMIT, (PSObject)new PSObjectReal(10.0));
        this.deviceStatus.setKey((PSObject)KEY_SCOPE_DEPTH, (PSObject)new PSObjectInt(0));
        this.out.write("% Created by " + Main.getNameVersion() + " ");
        Date date = new Date();
        this.out.write("on " + date + "\n");
        this.out.write("\\begin{pgfpicture}\n");
    }

    public void finish() throws IOException {
        int n;
        try {
            n = this.deviceStatus.get(KEY_SCOPE_DEPTH).toInt();
        }
        catch (PSError pSError) {
            n = -1;
        }
        for (int i = 0; i < n; ++i) {
            this.out.write("\\end{pgfscope}\n");
        }
        this.out.write("\\end{pgfpicture}\n");
    }

    void writePath(Path path) throws IOException, PSErrorUnimplemented {
        for (int i = 0; i < path.getSections().size(); ++i) {
            String string;
            String string2;
            PathSection pathSection = path.getSections().get(i);
            if (pathSection instanceof Moveto) {
                if (i >= path.getSections().size() - 1) continue;
                string2 = COOR_FORMAT.format(1.0E-4 * pathSection.getParam(0));
                string = COOR_FORMAT.format(1.0E-4 * pathSection.getParam(1));
                this.out.write("\\pgfpathmoveto{\\pgfqpoint{" + string2 + "cm}{" + string + "cm}}\n");
                continue;
            }
            if (pathSection instanceof Lineto) {
                string2 = COOR_FORMAT.format(1.0E-4 * pathSection.getParam(0));
                string = COOR_FORMAT.format(1.0E-4 * pathSection.getParam(1));
                this.out.write("\\pgfpathlineto{\\pgfqpoint{" + string2 + "cm}{" + string + "cm}}\n");
                continue;
            }
            if (pathSection instanceof Curveto) {
                string2 = COOR_FORMAT.format(1.0E-4 * pathSection.getParam(0));
                string = COOR_FORMAT.format(1.0E-4 * pathSection.getParam(1));
                String string3 = COOR_FORMAT.format(1.0E-4 * pathSection.getParam(2));
                String string4 = COOR_FORMAT.format(1.0E-4 * pathSection.getParam(3));
                String string5 = COOR_FORMAT.format(1.0E-4 * pathSection.getParam(4));
                String string6 = COOR_FORMAT.format(1.0E-4 * pathSection.getParam(5));
                this.out.write("\\pgfpathcurveto");
                this.out.write("{\\pgfqpoint{" + string2 + "cm}{" + string + "cm}}");
                this.out.write("{\\pgfqpoint{" + string3 + "cm}{" + string4 + "cm}}");
                this.out.write("{\\pgfqpoint{" + string5 + "cm}{" + string6 + "cm}}\n");
                continue;
            }
            if (pathSection instanceof Closepath) {
                this.out.write("\\pgfpathclose\n");
                continue;
            }
            throw new PSErrorUnimplemented("Can't handle " + pathSection.getClass().getName());
        }
    }

    public void stroke(GraphicsState graphicsState) throws IOException, PSError, ProgramError {
        this.updateDash(graphicsState);
        this.updateLineWidth(graphicsState);
        this.updateLineCap(graphicsState);
        this.updateLineJoin(graphicsState);
        this.updateMiterLimit(graphicsState);
        this.updateColor(graphicsState);
        this.writePath(graphicsState.getPath());
        this.out.write("\\pgfusepath{stroke}\n");
    }

    public void clip(Path path) throws IOException, PSErrorUnimplemented {
        this.writePath(path);
        this.out.write("\\pgfusepath{clip}\n");
    }

    public PGFDevice clone() {
        PGFDevice pGFDevice;
        try {
            pGFDevice = (PGFDevice)super.clone();
            pGFDevice.scopeStatus = this.scopeStatus.clone();
            pGFDevice.out = this.out;
            pGFDevice.options = this.options;
            pGFDevice.deviceStatus = this.deviceStatus;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            pGFDevice = null;
        }
        return pGFDevice;
    }

    public void fill(GraphicsState graphicsState) throws IOException, PSError, ProgramError {
        this.updateColor(graphicsState);
        this.writePath(graphicsState.getPath());
        this.out.write("\\pgfusepath{fill}\n");
    }

    public void eoclip(GraphicsState graphicsState) throws IOException, PSError {
        this.writePath(graphicsState.getClippingPath());
        this.out.write("\\pgfseteorule\\pgfusepath{clip}\\pgfsetnonzerorule\n");
    }

    public void eofill(GraphicsState graphicsState) throws IOException, PSError, ProgramError {
        this.updateColor(graphicsState);
        this.writePath(graphicsState.getPath());
        this.out.write("\\pgfseteorule\\pgfusepath{fill}\\pgfsetnonzerorule\n");
    }

    public void shfill(PSObjectDict pSObjectDict, GraphicsState graphicsState) throws PSError, IOException, ProgramError {
        this.updateColor(graphicsState);
        Shading shading = Shading.newShading(pSObjectDict);
        if (!(shading instanceof RadialShading)) {
            throw new PSErrorUnimplemented("Shading of this type " + shading);
        }
        this.radialShading((RadialShading)shading, graphicsState);
    }

    void radialShading(RadialShading radialShading, GraphicsState graphicsState) throws IOException, PSError {
        double d = graphicsState.getCtm().getMeanScaling();
        double d2 = graphicsState.getCtm().getXScaling() / d;
        double d3 = graphicsState.getCtm().getYScaling() / d;
        double d4 = graphicsState.getCtm().getRotation();
        double[] dArray = graphicsState.getCtm().transform(radialShading.getCoord(0.0));
        double[] dArray2 = graphicsState.getCtm().transform(radialShading.getCoord(1.0));
        double d5 = 1.0;
        if (radialShading.getExtend1()) {
            d5 = radialShading.getSForDistance(300000.0 / d, 1.0, Double.POSITIVE_INFINITY);
            dArray2 = graphicsState.getCtm().transform(radialShading.getCoord(d5));
        }
        this.startScope();
        this.out.write("\\pgfdeclareradialshading{eps2pgfshading}{\\pgfqpoint{");
        this.out.write(COOR_FORMAT.format(1.0E-4 * (dArray[0] - dArray2[0]) / d2) + "cm}{");
        this.out.write(COOR_FORMAT.format(1.0E-4 * (dArray[1] - dArray2[1]) / d3) + "cm}}{");
        double[] dArray3 = radialShading.fitLinearSegmentsOnColor(0.01);
        for (int i = 0; i < dArray3.length; ++i) {
            if (i > 0) {
                this.out.write(";");
            }
            double d6 = d * radialShading.getRadius(dArray3[i]);
            double[] dArray4 = radialShading.getColor(dArray3[i]);
            this.out.write("rgb(" + LENGTH_FORMAT.format(1.0E-4 * d6) + "cm)=");
            this.out.write("(" + COLOR_FORMAT.format(dArray4[0]));
            this.out.write("," + COLOR_FORMAT.format(dArray4[1]));
            this.out.write("," + COLOR_FORMAT.format(dArray4[2]) + ")");
        }
        if (d5 > 1.0) {
            double d7 = d * radialShading.getRadius(d5);
            double[] dArray5 = radialShading.getColor(1.0);
            this.out.write(";rgb(" + LENGTH_FORMAT.format(1.0E-4 * d7) + "cm)=");
            this.out.write("(" + COLOR_FORMAT.format(dArray5[0]));
            this.out.write("," + COLOR_FORMAT.format(dArray5[1]));
            this.out.write("," + COLOR_FORMAT.format(dArray5[2]) + ")");
        }
        this.out.write("}");
        this.out.write("\\pgflowlevelobj{");
        this.out.write("\\pgftransformshift{\\pgfqpoint{");
        this.out.write(LENGTH_FORMAT.format(1.0E-4 * dArray2[0]) + "cm}{");
        this.out.write(LENGTH_FORMAT.format(1.0E-4 * dArray2[1]) + "cm}}");
        if (Math.abs(d4) > 1.0E-10) {
            this.out.write("\\pgftransformrotate{" + COOR_FORMAT.format(d4) + "}");
        }
        if (Math.abs(d2 - 1.0) > 1.0E-10) {
            this.out.write("\\pgftransformxscale{" + d2 + "}");
        }
        if (Math.abs(d3 - 1.0) > 1.0E-10) {
            this.out.write("\\pgftransformyscale{" + d3 + "}");
        }
        this.out.write("}{\\pgfuseshading{eps2pgfshading}}");
        this.endScope();
    }

    private void updateLineCap(GraphicsState graphicsState) throws IOException, PSError {
        int n;
        int n2 = graphicsState.getLineCap();
        if (n2 != (n = this.scopeStatus.get(KEY_LAST_LINECAP).toInt())) {
            switch (n2) {
                case 0: {
                    this.out.write("\\pgfsetbuttcap\n");
                    break;
                }
                case 1: {
                    this.out.write("\\pgfsetroundcap\n");
                    break;
                }
                case 2: {
                    this.out.write("\\pgfsetrectcap\n");
                    break;
                }
                default: {
                    throw new PSErrorRangeCheck();
                }
            }
            this.scopeStatus.setKey((PSObject)KEY_LAST_LINECAP, (PSObject)new PSObjectInt(n2));
        }
    }

    private void updateLineJoin(GraphicsState graphicsState) throws IOException, PSError {
        int n;
        int n2 = this.scopeStatus.get(KEY_LAST_LINEJOIN).toInt();
        if (n2 != (n = graphicsState.getLineJoin())) {
            switch (n) {
                case 0: {
                    this.out.write("\\pgfsetmiterjoin\n");
                    break;
                }
                case 1: {
                    this.out.write("\\pgfsetroundjoin\n");
                    break;
                }
                case 2: {
                    this.out.write("\\pgfsetbeveljoin\n");
                    break;
                }
                default: {
                    throw new PSErrorRangeCheck();
                }
            }
            this.scopeStatus.setKey((PSObject)KEY_LAST_LINEJOIN, (PSObject)new PSObjectInt(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDash(GraphicsState graphicsState) throws IOException, PSError {
        String string = this.scopeStatus.get(KEY_LAST_DASHPATTERN).isis();
        double d = this.scopeStatus.get(KEY_LAST_DASHOFFSET).toReal();
        double d2 = graphicsState.getCtm().getMeanScaling();
        PSObjectArray pSObjectArray = new PSObjectArray();
        for (int i = 0; i < graphicsState.getDashPattern().size(); ++i) {
            pSObjectArray.addToEnd(new PSObjectReal(graphicsState.getDashPattern().get(i).toReal() * d2));
        }
        String string2 = pSObjectArray.isis();
        double d3 = graphicsState.getDashOffset() * d2;
        if (!string2.equals(string) || Math.abs(d - d3) > 1.0E-10) {
            this.out.write("\\pgfsetdash{");
            try {
                try {
                    int n = 0;
                    while (true) {
                        this.out.write("{" + LENGTH_FORMAT.format(1.0E-4 * pSObjectArray.get(n++).toReal()) + "cm}");
                    }
                }
                catch (PSErrorRangeCheck pSErrorRangeCheck) {
                    Object var13_11 = null;
                    this.out.write("}{" + LENGTH_FORMAT.format(1.0E-4 * d3) + "cm}\n");
                }
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                this.out.write("}{" + LENGTH_FORMAT.format(1.0E-4 * d3) + "cm}\n");
                throw throwable;
            }
            this.scopeStatus.setKey((PSObject)KEY_LAST_DASHPATTERN, (PSObject)pSObjectArray);
            this.scopeStatus.setKey((PSObject)KEY_LAST_DASHOFFSET, (PSObject)new PSObjectReal(d3));
        }
    }

    private void updateLineWidth(GraphicsState graphicsState) throws PSError, IOException {
        double d = this.scopeStatus.get(KEY_LAST_LINEWIDTH).toReal();
        double d2 = graphicsState.getLineWidth() * graphicsState.getCtm().getMeanScaling();
        if (Math.abs(d2 - d) > 1.0E-10) {
            this.out.write("\\pgfsetlinewidth{" + LENGTH_FORMAT.format(0.001 * d2) + "mm}\n");
            this.scopeStatus.setKey((PSObject)KEY_LAST_LINEWIDTH, (PSObject)new PSObjectReal(d2));
        }
    }

    private void updateMiterLimit(GraphicsState graphicsState) throws IOException, PSError {
        double d;
        double d2 = this.scopeStatus.get(KEY_LAST_MITERLIMIT).toReal();
        if (Math.abs(d2 - (d = graphicsState.getMiterLimit())) > 1.0E-6) {
            this.out.write("\\pgfsetmiterlimit{" + d + "}\n");
            this.scopeStatus.setKey((PSObject)KEY_LAST_MITERLIMIT, (PSObject)new PSObjectReal(d));
        }
    }

    public void startScope() throws IOException {
        this.out.write("\\begin{pgfscope}\n");
        try {
            int n = this.deviceStatus.get(KEY_SCOPE_DEPTH).toInt();
            this.deviceStatus.setKey((PSObject)KEY_SCOPE_DEPTH, (PSObject)new PSObjectInt(++n));
        }
        catch (PSError pSError) {
            // empty catch block
        }
    }

    public void endScope() throws IOException {
        try {
            int n = this.deviceStatus.get(KEY_SCOPE_DEPTH).toInt();
            if (n > 0) {
                this.out.write("\\end{pgfscope}\n");
                --n;
            }
            this.deviceStatus.setKey((PSObject)KEY_SCOPE_DEPTH, (PSObject)new PSObjectInt(n));
        }
        catch (PSError pSError) {
            // empty catch block
        }
    }

    private void updateColor(GraphicsState graphicsState) throws IOException, PSError, ProgramError {
        PSObjectArray pSObjectArray = this.scopeStatus.get(KEY_LAST_COLOR).toArray();
        String string = this.scopeStatus.get(KEY_LAST_COLSPACE).toString();
        PSColor pSColor = graphicsState.getColor();
        String string2 = pSColor.toString();
        string2 = string2.substring(string2.lastIndexOf(46) + 1, string2.lastIndexOf(64));
        int n = pSColor.getNrComponents();
        boolean bl = true;
        if (!string2.equals(string)) {
            bl = false;
        } else {
            for (int i = 0; i < n; ++i) {
                if (!(Math.abs(pSObjectArray.get(i).toReal() - pSColor.getLevel(i)) > 1.0E-6)) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            return;
        }
        String string3 = pSColor.getPreferredColorSpace();
        if (string3.equals("CMYK")) {
            double[] dArray = pSColor.getCMYK();
            this.out.write("\\definecolor{eps2pgf_color}{cmyk}{" + COLOR_FORMAT.format(dArray[0]) + "," + COLOR_FORMAT.format(dArray[1]) + "," + COLOR_FORMAT.format(dArray[2]) + "," + COLOR_FORMAT.format(dArray[3]) + "}");
        } else if (string3.equals("RGB")) {
            double[] dArray = pSColor.getRGB();
            this.out.write("\\definecolor{eps2pgf_color}{rgb}{" + COLOR_FORMAT.format(dArray[0]) + "," + COLOR_FORMAT.format(dArray[1]) + "," + COLOR_FORMAT.format(dArray[2]) + "}");
        } else if (string3.equals("Gray")) {
            double d = pSColor.getGray();
            this.out.write("\\definecolor{eps2pgf_color}{gray}{" + COLOR_FORMAT.format(d) + "}");
        } else {
            throw new ProgramError("Invalid preferred color space: " + string3);
        }
        this.out.write("\\pgfsetstrokecolor{eps2pgf_color}");
        this.out.write("\\pgfsetfillcolor{eps2pgf_color}\n");
        PSObjectArray pSObjectArray2 = new PSObjectArray();
        for (int i = 0; i < n; ++i) {
            pSObjectArray2.addToEnd(new PSObjectReal(pSColor.getLevel(i)));
        }
        this.scopeStatus.setKey((PSObject)KEY_LAST_COLOR, (PSObject)pSObjectArray2);
        this.scopeStatus.setKey((PSObject)KEY_LAST_COLSPACE, (PSObject)new PSObjectString(string2));
    }

    public void show(String string, double[] dArray, double d, double d2, String string2, GraphicsState graphicsState) throws IOException, PSError, ProgramError {
        this.updateColor(graphicsState);
        String string3 = COOR_FORMAT.format(1.0E-4 * dArray[0]);
        String string4 = COOR_FORMAT.format(1.0E-4 * dArray[1]);
        String string5 = "";
        if (string2.contains("t")) {
            string5 = "top,";
        } else if (string2.contains("B")) {
            string5 = "base,";
        } else if (string2.contains("b")) {
            string5 = "bottom,";
        }
        if (string2.contains("l")) {
            string5 = string5 + "left,";
        } else if (string2.contains("r")) {
            string5 = string5 + "right,";
        }
        double d3 = d2 / 72.0 * 72.27;
        String string6 = LENGTH_FORMAT.format(d);
        String string7 = "";
        if (!Double.isNaN(d3)) {
            string7 = string7 + "\\fontsize{" + FONTSIZE_FORMAT.format(d3) + "}{" + FONTSIZE_FORMAT.format(1.2 * d3) + "}\\selectfont{";
        }
        string7 = string7 + string;
        if (!Double.isNaN(d3)) {
            string7 = string7 + "}";
        }
        this.out.write(String.format("\\pgftext[%sx=%scm,y=%scm,rotate=%s]{%s}\n", string5, string3, string4, string6, string7));
    }

    public void drawDot(double d, double d2) throws IOException {
        this.out.write("\\begin{pgfscope}\\pgfsetfillcolor{red}\\pgfpathcircle{\\pgfqpoint{" + 1.0E-4 * d + "cm}{" + 1.0E-4 * d2 + "cm}}{0.5pt}\\pgfusepath{fill}\\end{pgfscope}\n");
    }

    public void drawRect(double[] dArray, double[] dArray2) throws IOException {
        this.out.write("\\begin{pgfscope}\\pgfsetstrokecolor{blue}\\pgfsetlinewidth{0.1pt}\\pgfpathrectangle{\\pgfqpoint{" + 1.0E-4 * dArray[0] + "cm}{" + 1.0E-4 * dArray[1] + "cm}}{\\pgfqpoint{" + 1.0E-4 * (dArray2[0] - dArray[0]) + "cm}{" + 1.0E-4 * (dArray2[1] - dArray[1]) + "cm}}\\pgfusepath{stroke}\\end{pgfscope}\n");
    }

    public void image(Image image) throws PSError, IOException, ProgramError {
        String string = this.options.getOutputFile().getName();
        int n = string.lastIndexOf(46);
        String string2 = n >= 0 ? string.substring(0, n) : string;
        string2 = string2 + "-image" + this.nextImage++;
        File file = new File(this.options.getOutputFile().getParent(), string2 + ".eps");
        File file2 = new File(this.options.getOutputFile().getParent(), string2 + ".pdf");
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            EpsImageCreator.writeImage(bufferedOutputStream, image, file.getName());
            ((OutputStream)bufferedOutputStream).close();
            BufferedOutputStream bufferedOutputStream2 = new BufferedOutputStream(new FileOutputStream(file2));
            PdfImageCreator pdfImageCreator = new PdfImageCreator();
            pdfImageCreator.writeImage(bufferedOutputStream2, image, file2.getName());
            ((OutputStream)bufferedOutputStream2).close();
            double[][] dArray = image.getDeviceBbox();
            int[] nArray = image.getCornerMap();
            double d = dArray[nArray[0]][0];
            double d2 = dArray[nArray[0]][1];
            double d3 = dArray[nArray[1]][0];
            double d4 = dArray[nArray[1]][1];
            double d5 = dArray[nArray[3]][0];
            double d6 = dArray[nArray[3]][1];
            double d7 = image.getAngle();
            double d8 = Math.min(Math.min(d, d5), d3);
            double d9 = Math.min(Math.min(d2, d6), d4);
            String string3 = COOR_FORMAT.format(1.0E-4 * d8);
            String string4 = COOR_FORMAT.format(1.0E-4 * d9);
            this.out.write(String.format("\\pgftext[at=\\pgfqpoint{%scm}{%scm},left,bottom]{\\includegraphics[angle=%f]{%s}}\n", string3, string4, d7, string2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PSErrorIOError();
        }
        catch (IOException iOException) {
            throw new PSErrorIOError();
        }
    }
}

