/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.colors;

import java.io.IOException;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.Interpreter;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.objects.PSObjectReal;
import net.sf.eps2pgf.ps.resources.colors.DeviceRGB;
import net.sf.eps2pgf.ps.resources.colors.PSColor;

public abstract class CIEBased
extends PSColor {
    protected static final PSObjectName RANGELMN = new PSObjectName("/RangeLMN");
    protected static final PSObjectName DECODELMN = new PSObjectName("/DecodeLMN");
    protected static final PSObjectName MATRIXLMN = new PSObjectName("/MatrixLMN");
    protected static final PSObjectName WHITEPOINT = new PSObjectName("/WhitePoint");
    protected static final PSObjectName BLACKPOINT = new PSObjectName("/BlackPoint");
    private PSObjectDict dict;
    private double[] xyzLevels = new double[3];
    private static Interpreter interp = null;

    protected static PSObjectDict checkCommonEntries(PSObjectDict pSObjectDict) throws PSError, ProgramError {
        Object object;
        if (!pSObjectDict.known(RANGELMN)) {
            object = new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0};
            pSObjectDict.setKey((PSObject)RANGELMN, (PSObject)new PSObjectArray((double[])object));
        }
        if (!pSObjectDict.known(DECODELMN)) {
            object = new PSObjectArray();
            ((PSObjectArray)object).addToEnd(new PSObjectArray("{}"));
            ((PSObjectArray)object).addToEnd(new PSObjectArray("{}"));
            ((PSObjectArray)object).addToEnd(new PSObjectArray("{}"));
            pSObjectDict.setKey((PSObject)DECODELMN, (PSObject)object);
        }
        if (!pSObjectDict.known(MATRIXLMN)) {
            object = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
            pSObjectDict.setKey((PSObject)MATRIXLMN, (PSObject)new PSObjectArray((double[])object));
        }
        pSObjectDict.get(WHITEPOINT).toArray();
        if (!pSObjectDict.known(BLACKPOINT)) {
            object = new double[]{0.0, 0.0, 0.0};
            pSObjectDict.setKey((PSObject)BLACKPOINT, (PSObject)new PSObjectArray((double[])object));
        }
        return pSObjectDict;
    }

    protected static double decode(double d, PSObjectArray pSObjectArray) throws PSError, ProgramError {
        if (interp == null) {
            try {
                interp = new Interpreter();
            }
            catch (IOException iOException) {
                throw new ProgramError("Creating new interpreter generated an IOException.");
            }
        }
        interp.getOpStack().push(new PSObjectReal(d));
        interp.getExecStack().push(pSObjectArray);
        interp.run();
        return interp.getOpStack().pop().toReal();
    }

    public PSObjectArray getColorSpace() {
        PSObjectArray pSObjectArray = new PSObjectArray();
        pSObjectArray.addToEnd(this.getFamilyName());
        pSObjectArray.addToEnd(this.getDict());
        return pSObjectArray;
    }

    public double[] getCMYK() {
        double[] dArray = this.getRGB();
        return DeviceRGB.convertRGBtoCMYK(dArray[0], dArray[1], dArray[2]);
    }

    public double getGray() {
        double[] dArray = this.getRGB();
        return 0.3 * dArray[0] + 0.59 * dArray[1] + 0.11 * dArray[2];
    }

    public double[] getHSB() {
        double[] dArray = this.getRGB();
        return DeviceRGB.convertRGBtoHSB(dArray[0], dArray[1], dArray[2]);
    }

    public String getPreferredColorSpace() {
        return "RGB";
    }

    public double[] getRGB() {
        int n;
        double d = this.xyzLevels[0];
        double d2 = this.xyzLevels[1];
        double d3 = this.xyzLevels[2];
        double[] dArray = new double[]{3.241 * d + -1.5374 * d2 + -0.4986 * d3, -0.9692 * d + 1.876 * d2 + 0.0416 * d3, 0.0556 * d + -0.204 * d2 + 1.057 * d3};
        for (n = 0; n < 3; ++n) {
            dArray[n] = Math.max(0.0, Math.min(1.0, dArray[n]));
        }
        for (n = 0; n < 3; ++n) {
            dArray[n] = dArray[n] <= 0.00304 ? 12.92 * dArray[n] : 1.055 * Math.pow(dArray[n], 0.4166666666666667) - 0.055;
        }
        return dArray;
    }

    public abstract void setColor(double[] var1) throws PSError, ProgramError;

    protected double[] lmnToXyz(double[] dArray) throws PSError, ProgramError {
        PSObjectArray pSObjectArray = this.dict.get(RANGELMN).toArray();
        for (int i = 0; i < 3; ++i) {
            double d = pSObjectArray.getReal(2 * i);
            double d2 = pSObjectArray.getReal(2 * i + 1);
            dArray[i] = Math.max(d, Math.min(d2, dArray[i]));
        }
        double[] dArray2 = new double[3];
        PSObjectArray pSObjectArray2 = this.dict.get(DECODELMN).toArray();
        for (int i = 0; i < 3; ++i) {
            PSObjectArray pSObjectArray3 = pSObjectArray2.get(i).toProc();
            dArray2[i] = CIEBased.decode(dArray[i], pSObjectArray3);
        }
        double[] dArray3 = new double[3];
        PSObjectArray pSObjectArray4 = this.dict.get(MATRIXLMN).toArray();
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = dArray2[0] * pSObjectArray4.getReal(i) + dArray2[1] * pSObjectArray4.getReal(3 + i) + dArray2[2] * pSObjectArray4.getReal(6 + i);
        }
        return dArray3;
    }

    protected void setDict(PSObjectDict pSObjectDict) {
        this.dict = pSObjectDict;
    }

    protected PSObjectDict getDict() {
        return this.dict;
    }

    protected void setXyzLevels(double[] dArray) {
        for (int i = 0; i < 3; ++i) {
            this.xyzLevels[i] = dArray[i];
        }
    }
}

