% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel-utils.R
\name{normalize_kernel}
\alias{normalize_kernel}
\title{Normalize a kernel}
\usage{
normalize_kernel(k, warning_enabled = TRUE)
}
\arguments{
\item{k}{\strong{[matrix]} The kernel.}

\item{warning_enabled}{\strong{[logical]} Whether to unable warnings, default
to \code{TRUE}.}
}
\value{
The normalized kernel, a \code{matrix}.
}
\description{
A normalized kernel is one that, if given a data matrix that is all 1s, will
result in 1. This function applies a scalier multiple to the kernel to make
it normalized, if possible. Otherwise, it optionally warns and returns the
input kernel.
}
\examples{

kernel <- distance_kernel(vertical_radius = 2, horizontal_radius = 2)
kernel_norm <- normalize_kernel(kernel)
sum(kernel_norm)

}
