% Generated by roxygen2 (4.0.1): do not edit by hand
\name{comparative.comm}
\alias{comparative.comm}
\alias{print.comparative.comm}
\title{Creates a community comparative ecology object, the basis of all
functions in pez}
\usage{
comparative.comm(phy, comm, traits = NULL, env = NULL, warn = TRUE,
  force.root = -1)

\method{print}{comparative.comm}(x, ...)
}
\arguments{
\item{phy}{phylogeny (in \code{\link[ape:phylo]{phylo}} format) of
species}

\item{comm}{community \code{matrix} (as used in
\code{\link{vegan}}) with species as columns and rows as
communities. Must contain \code{rownames} and \code{colnames}; NAs
are not checked for but probably unwise.}

\item{traits}{\code{data.frame} of species traits, with
\code{rownames} matching \code{comm}. Saved in the \code{data} slot
of the resulting \code{comparative.comm} object for compatibility
with \code{\link[caper:comparative.data]{comparative.data}}.}

\item{env}{\code{data.frame} of environmental data with
\code{rownames} matching \code{comm}}

\item{warn}{whether to warn if species/sites are dropped when
creating object (default: TRUE)}

\item{force.root}{if \code{phy} is unrooted, a \code{root.edge} of
value force.root will be added (default: -1, which means this will
never happen). Rarely needed, rarely advisable.}

\item{x}{\code{comparative.comm} object to be printed}

\item{...}{not currently used}
}
\value{
comparative.comm object
}
\description{
Basic checking of whether the input data match up is performed; you
need only supply \code{comm} and \code{phy}, nothing else is
mandatory. You can manipulate the internals of
\code{comparative.comm}, or use the wrappers inside \code{pez} to
keep everything in order. Examples of these features are given
below; they are described in detailed at \code{\link{cc.manip}}.
}
\note{
\code{comparative.comm} is compatible with
\code{\link[caper:comparative.data]{comparative.data}}; this means
that the slot for species' trait data is called \code{data}. I
appreciate this is somewhat unwieldy, but hopefully you agree it is
helpful in the long-term.
}
\examples{
data(laja)
data <- comparative.comm(invert.tree, river.sites, invert.traits, river.env)
#Subset on species, then sites
data <- data[1:5,]
data <- data[,1:5]
#Site and species can be manipulated
species(data)
sites(data)[1:3] <- c("lovely", "invert", "sites")
#Other data can be viewed
trait.names(data)
env.names(data)
#Get assemblage phylogenies of all sites
assemblage.phylogenies(data)
#Do some manual manipulation of your objects (NOTE: $data for traits)
data$data$new.trait <- sample(letters, nrow(data$comm), replace=TRUE)
}
\author{
Will Pearse
}
\seealso{
\code{\link{plot.comparative.comm}} \code{\link{cc.manip}} \code{link[caper:comparative.data]{comparative.data}}
}

