% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_sphericity.R
\name{check_sphericity}
\alias{check_sphericity}
\title{Check model for violation of sphericity}
\usage{
check_sphericity(x, ...)
}
\arguments{
\item{x}{A model object.}

\item{...}{Arguments passed to \code{car::Anova}.}
}
\value{
Invisibly returns the p-values of the test statistics. A p-value <
  0.05 indicates a violation of sphericity.
}
\description{
Check model for violation of sphericity
}
\examples{
if (require("car")) {
  soils.mod <- lm(
    cbind(pH, N, Dens, P, Ca, Mg, K, Na, Conduc) ~ Block + Contour * Depth,
    data = Soils
  )

  check_sphericity(Manova(soils.mod))
}
}
