% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_check.R
\name{pp_check}
\alias{pp_check}
\alias{pp_check.lm}
\alias{posterior_predictive_check}
\alias{check_posterior_predictions}
\title{Posterior predictive checks for frequentist models}
\usage{
pp_check(object, ...)

\method{pp_check}{lm}(object, iterations = 50, check_range = FALSE, re_formula = NULL, ...)

posterior_predictive_check(
  object,
  iterations = 50,
  check_range = FALSE,
  re_formula = NULL,
  ...
)

check_posterior_predictions(
  object,
  iterations = 50,
  check_range = FALSE,
  re_formula = NULL,
  ...
)
}
\arguments{
\item{object}{A statistical model.}

\item{...}{Passed down to \code{simulate()}.}

\item{iterations}{The number of draws to simulate/bootstrap.}

\item{check_range}{Logical, if \code{TRUE}, includes a plot with the minimum
value of the original response against the minimum values of the replicated
responses, and the same for the maximum value. This plot helps judging whether
the variation in the original data is captured by the model or not
(\cite{Gelman et al. 2020, pp.163}). The minimum and maximum values of \code{y} should
be inside the range of the related minimum and maximum values of \code{yrep}.}

\item{re_formula}{Formula containing group-level effects (random effects) to
be considered in the simulated data. If \code{NULL} (default), condition
on all random effects. If \code{NA} or \code{~0}, condition on no random
effects. See \code{simulate()} in \strong{lme4}.}
}
\value{
A data frame of simulated responses and the original response vector.
}
\description{
Posterior predictive checks for frequentist models.
}
\details{
Posterior predictive checks means \dQuote{simulating replicated data
  under the fitted model and then comparing these to the observed data}
  \cite{(Gelman and Hill, 2007, p. 158)}. Posterior predictive checks
  can be used to \dQuote{look for systematic discrepancies between real and
  simulated data} \cite{(Gelman et al. 2014, p. 169)}.
  \cr \cr
  An example how posterior predictive checks can also be used for model
  comparison is following plot (from \cite{Gabry et al. 2019, Figure 6}):
  \cr
  \if{html}{\cr \figure{pp_check.png}{options: width="90\%" alt="Posterior Predictive Check"} \cr}
  The model shown in the right panel (b) can simulate new data that are more
  similar to the observed outcome than the model in the left panel (a). Thus,
  model (b) is likely to be preferred over model (a).
}
\note{
The default-method, \code{pp_check.default()} is in package \pkg{bayesplot}.
Thus, \pkg{performance} adds \code{pp_check()}-methods for different classes and
packages (like \code{lm}, \code{merMod}, \code{glmmTMB}, ...). However, since
it might be that not all model objects that have a \code{simulate()} function
are covered, and those objects probably can't be passed down to the default-method,
there is also a "generic" \code{posterior_predictive_check()} function (and
its alias \code{check_posterior_predictions()}), which just calls
\code{pp_check.lm()}. Thus, every model object that has a \code{simulate()}-method
should work with \code{posterior_predictive_check()}.
}
\examples{
library(performance)
model <- lm(Sepal.Length ~ Species * Petal.Width + Petal.Length, data = iris)
if (require("ggplot2") && require("see")) {
  pp_check(model)
}

}
\references{
\itemize{
  \item Gabry, J., Simpson, D., Vehtari, A., Betancourt, M., & Gelman, A. (2019). Visualization in Bayesian workflow. Journal of the Royal Statistical Society: Series A (Statistics in Society), 182(2), 389–402. https://doi.org/10.1111/rssa.12378
  \item Gelman, A., & Hill, J. (2007). Data analysis using regression and multilevel/hierarchical models. Cambridge; New York: Cambridge University Press.
  \item Gelman, A., Carlin, J. B., Stern, H. S., Dunson, D. B., Vehtari, A., & Rubin, D. B. (2014). Bayesian data analysis. (Third edition). CRC Press.
  \item Gelman, A., Hill, J., & Vehtari, A. (2020). Regression and Other Stories. Cambridge University Press.
}
}
