% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_convergence.R
\name{check_convergence}
\alias{check_convergence}
\title{Convergence test for mixed effects models}
\usage{
check_convergence(x, tolerance = 0.001, ...)
}
\arguments{
\item{x}{A \code{merMod}-object.}

\item{tolerance}{Indicates up to which value the convergence result is
accepted. The smaller \code{tolerance} is, the stricter the test
will be.}

\item{...}{Currently not used.}
}
\value{
\code{TRUE} if convergence is fine and \code{FALSE} if convergence
  is suspicious. Additionally, the convergence value is returned as attribute.
}
\description{
\code{check_convergence()} provides an alternative convergence
  test for \code{\link[lme4]{merMod}}-objects.
}
\details{
\code{check_convergence()} provides an alternative convergence test for
  \code{\link[lme4]{merMod}}-objects, as discussed
  \href{https://github.com/lme4/lme4/issues/120}{here}
  and suggested by Ben Bolker in
  \href{https://github.com/lme4/lme4/issues/120#issuecomment-39920269}{this comment}.
  Further details can be found in \code{\link[lme4]{convergence}}.
}
\examples{
library(lme4)
data(cbpp)
set.seed(1)
cbpp$x <- rnorm(nrow(cbpp))
cbpp$x2 <- runif(nrow(cbpp))

model <- glmer(
  cbind(incidence, size - incidence) ~ period + x + x2 + (1 + x | herd),
  data = cbpp,
  family = binomial()
)

check_convergence(model)
}
