% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AB.R
\name{AB}
\alias{AB}
\title{Two-Group Permutation Test}
\usage{
AB(a, b, rand = 9999, seed = 1)
}
\arguments{
\item{a}{the measurement of responses of the first group.}

\item{b}{the measurement of responses of the second group.}

\item{rand}{an integer, the number of randomization samples. The default value
is 9999.}

\item{seed}{an integer, the seed for random number generation. Setting a seed
ensures the reproducibility of the result. See \code{\link{set.seed}} for
more details.}
}
\value{
\code{AB} returns an one-row data frame with 6 columns:
 \item{\code{nA}}{the sample size of the first group.}
 \item{\code{mean.A}}{the mean responses of the first group.}
 \item{\code{nB}}{the sample size of the second group.}
 \item{\code{mean.B}}{the mean responses of the second group.}
 \item{\code{mean.dif}}{the difference between two mean responses.}
 \item{\code{pval}}{the p-value.}
}
\description{
\code{AB} performs A/B testing for two-group experiments.
}
\examples{
AB(c(19, 22, 25, 26), c (23, 33, 40))

}
\references{
Ernst, M. D. (2004). Permutation Methods: A Basis for Exact
 Inference. Statistical Science, 19(4), 676–685.
 \doi{10.1214/088342304000000396}.
}
