% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot.pense_cvfit}
\alias{plot.pense_cvfit}
\title{Plot Method for Penalized Estimates With Cross-Validation}
\usage{
\method{plot}{pense_cvfit}(x, what = c("cv", "coef.path"), se_mult = 1, ...)
}
\arguments{
\item{x}{fitted estimates with cross-validation information.}

\item{what}{plot either the CV performance or the coefficient path.}

\item{se_mult}{if plotting CV performance, multiplier of the estimated SE.}

\item{...}{currently ignored.}
}
\description{
Plot the cross-validation performance or the coefficient path for fitted penalized elastic net S- or LS-estimates
of regression.
}
\examples{
# Compute the PENSE regularization path for Freeny's revenue data
# (see ?freeny)
data(freeny)
x <- as.matrix(freeny[ , 2:5])

regpath <- pense(x, freeny$y, alpha = 0.5)
plot(regpath)

# Extract the coefficients at a certain penalization level
coef(regpath, lambda = regpath$lambda[40])

# What penalization level leads to good prediction performance?
cv_results <- pense_cv(x, freeny$y, alpha = 0.5, cv_repl = 2,
                       cv_k = 4)
plot(cv_results, se_mult = 1)

# Extract the coefficients at the penalization level with
# smallest prediction error ...
coef(cv_results)
# ... or at the penalization level with prediction error
# statistically indistinguishable from the minimum.
coef(cv_results, lambda = 'se')
}
\seealso{
Other functions for plotting and printing: 
\code{\link{plot.pense_fit}()},
\code{\link{prediction_performance}()},
\code{\link{summary.pense_cvfit}()}
}
\concept{functions for plotting and printing}
