% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{fitted,penfa-method}
\alias{fitted,penfa-method}
\title{Model-implied moments for a \code{penfa} object}
\usage{
\S4method{fitted}{penfa}(object, labels = TRUE)
}
\arguments{
\item{object}{An object of class \code{penfa}, found as a result of a call
to \code{penfa}.}

\item{labels}{Logical. If \code{TRUE}, the model-implied moments are named
according to the item names used in the model syntax.}
}
\value{
A list of the model-implied moments for each group: \code{cov}
contains the implied covariance matrix, and \code{mean} the implied mean
vector. If just the covariance matrix is analyzed, only the \code{cov}
argument is returned.
}
\description{
An S4 method returning the model-implied moments for an object of class
\code{penfa}. For every group, a list with the model-implied  moments is
returned.
}
\examples{


data(ccdata)

syntax = 'help  =~   h1 + h2 + h3 + h4 + h5 + h6 + h7 + 0*v1 + v2 + v3 + v4 + v5
          voice =~ 0*h1 + h2 + h3 + h4 + h5 + h6 + h7 +   v1 + v2 + v3 + v4 + v5'

alasso_fit <- penfa(## factor model
                    model  = syntax,
                    data   = ccdata,
                    std.lv = TRUE,
                    ## penalization
                    pen.shrink = "alasso",
                    eta = list(shrink = c("lambda" = 0.01), diff = c("none" = 0)),
                    ## automatic procedure
                    strategy = "auto")

fitted(alasso_fit)



}
\seealso{
\code{\link{penfa}}, \code{\link{penfa-class}}
}
