% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_internal.R
\name{internalplot}
\alias{internalplot}
\alias{.pedAlignment}
\alias{.pedAnnotation}
\alias{.pedScaling}
\alias{.drawPed}
\alias{.annotatePed}
\title{Internal plot methods}
\usage{
.pedAlignment(
  x = NULL,
  plist = NULL,
  arrows = FALSE,
  twins = NULL,
  packed = TRUE,
  width = 10,
  align = c(1.5, 2),
  hints = NULL,
  ...
)

.pedAnnotation(
  x,
  title = NULL,
  marker = NULL,
  sep = "/",
  missing = "-",
  showEmpty = FALSE,
  labs = labels(x),
  col = 1,
  aff = NULL,
  carrier = NULL,
  hatched = NULL,
  deceased = NULL,
  starred = NULL,
  textInside = NULL,
  textAbove = NULL,
  fouInb = "autosomal",
  ...
)

.pedScaling(
  alignment,
  annotation,
  cex = 1,
  symbolsize = 1,
  margins = 1,
  addSpace = 0,
  xlim = NULL,
  ylim = NULL,
  ...
)

.drawPed(alignment, annotation, scaling)

.annotatePed(
  alignment,
  annotation,
  scaling,
  font = NULL,
  fam = NULL,
  col = NULL,
  colUnder = 1,
  colInside = 1,
  colAbove = 1,
  cex.main = NULL,
  font.main = NULL,
  col.main = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{\link[=ped]{ped()}} object.}

\item{plist}{Alignment list with format similar to
\code{\link[kinship2:align.pedigree]{kinship2::align.pedigree()}}.}

\item{arrows}{A logical (default = FALSE). If TRUE, the pedigree is plotted
as a DAG, i.e., with arrows connecting parent-child pairs.}

\item{twins}{A data frame with columns \code{id1}, \code{id2} and \code{code}, passed on to
the \code{relation} parameter of \code{\link[kinship2:plot.pedigree]{kinship2::plot.pedigree()}}.}

\item{packed, width, align}{Parameters passed on to
\code{\link[kinship2:align.pedigree]{kinship2::align.pedigree()}}. Can usually be left untouched.}

\item{hints}{An optional list of hints passed on to
\code{\link[kinship2:align.pedigree]{kinship2::align.pedigree()}}.}

\item{\dots}{Further parameters passed between methods.}

\item{title}{The plot title. If NULL (default) or '', no title is added to
the plot.}

\item{marker}{Either a vector of names or indices referring to markers
attached to \code{x}, a \code{marker} object, or a list of such. The genotypes for
the chosen markers are written below each individual in the pedigree, in
the format determined by \code{sep} and \code{missing}. See also \code{showEmpty}. If NULL
(the default), no genotypes are plotted.}

\item{sep}{A character of length 1 separating alleles for diploid markers.}

\item{missing}{The symbol (integer or character) for missing alleles.}

\item{showEmpty}{A logical, indicating if empty genotypes should be included.}

\item{labs}{A vector or function controlling the individual labels included
in the plot. Alternative forms:
\itemize{
\item If \code{labs} is a vector with nonempty intersection with \code{labels(x)}, these
individuals will be labelled. If the vector is named, then the (non-empty)
names are used instead of the ID label. (See Examples.)
\item If \code{labs} is NULL, or has empty intersection with \code{labels(x)}, then no
labels are drawn.
\item If \code{labs} is the word "num", then all individuals are numerically
labelled following the internal ordering.
\item If \code{labs} is a function, it is replaced with \code{labs(x)} and handled as
above. (See Examples.)
}}

\item{col}{A vector of colours for the pedigree members, recycled if
necessary. Alternatively, \code{col} can be a list assigning colours to specific
members. For example if \code{col = list(red = "a", blue = c("b", "c"))} then
individual "a" will be red, "b" and "c" blue, and everyone else black. By
default everyone is black.}

\item{aff}{A vector of labels identifying members whose plot symbols should
be filled. (This is typically used in medical pedigrees to indicate
affected members.)}

\item{carrier}{A vector of labels identifying members whose plot symbols
should be marked with a dot. (This is typically used in medical pedigrees
to indicate unaffected carriers of the disease allele.)}

\item{hatched}{A vector of labels identifying members whose plot symbols
should be hatched.}

\item{deceased}{A vector of labels indicating deceased pedigree members.}

\item{starred}{A vector of labels indicating pedigree members that should be
marked with a star in the pedigree plot.}

\item{textInside, textAbove}{Character vectors of text to be printed inside or
above pedigree symbols.}

\item{fouInb}{Either "autosomal" (default), "x" or NULL. If "autosomal" or
"x", inbreeding coefficients are added to the plot above the inbred
founders. If NULL, or if no founders are inbred, nothing is added.}

\item{alignment}{List of alignment details, as returned by \code{\link[=.pedAlignment]{.pedAlignment()}}.}

\item{annotation}{List of annotation details as returned by
\code{\link[=.pedAnnotation]{.pedAnnotation()}}.}

\item{cex}{Expansion factor controlling font size. This also affects symbol
sizes, which by default have the width of 2.5 characters. Default: 1.}

\item{symbolsize}{Expansion factor for pedigree symbols. Default: 1.}

\item{margins}{A numeric indicating the plot margins. If a single number is
given, it is recycled to length 4.}

\item{addSpace}{A numeric of length 4, indicating extra padding (in inches)
around the pedigree inside the plot region. Default: 0.}

\item{xlim, ylim}{Numeric vectors of length 2, used to set \code{par("usr")}
explicitly. Rarely needed by end users.}

\item{scaling}{List of scaling parameters as returned by \code{\link[=.pedScaling]{.pedScaling()}}.}

\item{font, fam}{Arguments passed on to \code{\link[=text]{text()}}.}

\item{colUnder, colInside, colAbove}{Colour vectors.}

\item{cex.main, col.main, font.main}{Parameters passed on to \code{\link[=title]{title()}}.}
}
\description{
The main purpose of this page is to document the procedure and options for
plotting pedigrees. Most of the arguments shown here may be supplied directly
in \code{plot(x, ...)}, when \code{x} is a pedigree. See \code{\link[=plot.ped]{plot.ped()}} for many
examples.
}
\details{
The workflow of \code{plot.ped(x, ...)} is approximately as follows:

\if{html}{\out{<div class="sourceCode">}}\preformatted{
# Calculate plot parameters

align = .pedAlignment(x, ...)

annot = .pedAnnotation(x, ...)

scale = .pedScaling(align, annot, ...)

# Produce plot

.drawPed(align, annot, scale)

.annotatePed(align, annot, scale)

}\if{html}{\out{</div>}}
}
\examples{
x = nuclearPed()

align = .pedAlignment(x)
annot = .pedAnnotation(x)
scale = .pedScaling(align, annot)

frame()
drawPed(align, annot, scale)

}
