% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_transfer.R
\name{transferMarkers}
\alias{transferMarkers}
\title{Transfer marker data}
\usage{
transferMarkers(
  from,
  to,
  ids = NULL,
  idsFrom = ids,
  idsTo = ids,
  erase = TRUE,
  matchNames = TRUE,
  checkSex = FALSE
)
}
\arguments{
\item{from}{A \code{ped} or \code{singleton} object, or a list of such objects.}

\item{to}{A \code{ped} or \code{singleton} object, or a list of such objects.}

\item{ids}{A vector of ID labels. This should be used only if the individuals
have the same name in both pedigrees; otherwise use \code{idsFrom} and \code{idsTo}
instead.}

\item{idsFrom, idsTo}{Vectors of equal length, denoting source individuals (in
the \code{from} pedigree) and target individuals (in the \code{to} pedigree),
respectively.}

\item{erase}{A logical. If \code{TRUE} (default), all markers attached to \code{to} are
erased prior to transfer, and new marker objects are created with the same
attributes as in \code{from}. If \code{FALSE} no new marker objects are attached to
\code{to}. Only the genotypes of the \code{ids} individuals are modified, while
genotypes for other pedigree members - and marker attributes - remain
untouched.}

\item{matchNames}{A logical, only relevant if \code{erase = FALSE}. If \code{matchNames = TRUE} (default) marker names are used to ensure genotypes are transferred
into the right markers, The output contains only markers present in \code{from},
in the same order. (An error is raised if the markers are not named.)}

\item{checkSex}{A logical. If TRUE, it is checked that \code{fromIds} and \code{toIds}
have the same sex. Default: FALSE.}
}
\value{
A \code{ped} object (or a list of such) similar to \code{to}, but where all
individuals also present in \code{from} have marker genotypes copied over.  Any
previous marker data is erased.
}
\description{
Transfer marker data between pedigrees. Any markers attached to the target
are overwritten.
}
\details{
By default, genotypes are transferred between all individuals present in both
pedigrees.
}
\examples{

x = nuclearPed(fa = "father", mo = "mother", children = "boy")
m = marker(x, father = 1:2, mother = 1, boy = 1:2)
x = setMarkers(x, m)

y = list(singleton("father"), nuclearPed(mo = "mother", children = "boy"))

# By default all common individuals are transferred
transferMarkers(x, y)

# Transfer data for the boy only
transferMarkers(x, y, ids = "boy")

# Transfer without erasing marker attributes or others genotypes
# Note that `erase = FALSE` requires markers to be named
z = nuclearPed(children = "boy")
z = setMarkers(z, marker(z, '1' = c(2,2), alleles = 1:2, afreq = c(.1, .9)))
name(x, 1) = name(z, 1) = 'M1'
z2 = transferMarkers(x, z, ids = "boy", erase = FALSE)
z2
# Frequencies are not transferred
afreq(z2, 1)

}
